package w83b.w83bDAO;


import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bActasIncidenciaBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bDocBeanIncidencia;
import w83b.w83bBeans.W83bEscrutinioBean;
import w83b.w83bBeans.W83bHistorialIncidenciaBean;
import w83b.w83bBeans.W83bIncidenciaHistorialActaBean;
import w83b.w83bBeans.W83bIncidenciaImpugnacionBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bIncidenciasSubsanacionCambioBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bBeans.W83bPapeletasBean;
import w83b.w83bBeans.W83bTipoDocumentoBean;
import w83b.w83bBeans.W83bTramiteIncidenciaBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCierreBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosIncidenciasVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDiferenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bEscrutiniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasAuditoriaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasDocsBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasHistorialBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasTipoSustitucionBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMigracionBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPapeletasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSubsanacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTiposDocumentosVistaBD;
import w83b.w83bManager.W83bComunes;
import w83b.w83bManager.W83bIComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bIncidenciasDAO.
 */
public class W83bIncidenciasDAO implements W83bIIncidenciasDAO {
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();
		
		if(contar){
			strSql.append("SELECT COUNT(");
//			strSql.append(W83bIncidenciasVistaBD.nacta)
			strSql.append("DISTINCT(");
			strSql.append(W83bIncidenciasVistaBD.territorioincidencias);
			strSql.append("||'/'|| ");
			strSql.append(W83bIncidenciasVistaBD.anyoincidencias);
			strSql.append("||'/'|| ");
			strSql.append(W83bIncidenciasVistaBD.numincidenciasencillocompleto);
			strSql.append(") ");
			strSql.append(") ");
		}else{
			strSql.append("SELECT ");
			strSql.append("DISTINCT(");
			strSql.append(W83bIncidenciasVistaBD.numacta).append("), ");
			strSql.append("TO_CHAR(");
			strSql.append(W83bIncidenciasVistaBD.fentrada).append(",?) AS ").append(W83bIncidenciasVistaBD.fentrada);
			strSql.append(", ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(W83bIncidenciasVistaBD.tipsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipsolicitante_es).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipsolicitante_eu).append(", upper(");
			strSql.append(W83bIncidenciasVistaBD.nomsolicitante).append(") as ");
			strSql.append(W83bIncidenciasVistaBD.nomsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numactaCompletoInt).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia_es).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia_eu).append(", ");
			strSql.append(W83bIncidenciasVistaBD.territorioincidencias).append(", ");
			strSql.append(W83bIncidenciasVistaBD.anyoincidencias).append(", ");
			strSql.append(W83bIncidenciasVistaBD.nincidencias).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numincidenciasencillocompleto).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numincidenciaCompleto).append(", ");
			strSql.append(W83bIncidenciasVistaBD.territorioincidencias);
			strSql.append("||'/'|| ");
			strSql.append(W83bIncidenciasVistaBD.anyoincidencias);
			strSql.append("||'/'|| ");
			strSql.append(W83bIncidenciasVistaBD.numincidenciasencillocompleto).append(" AS NINCIDENCIACOMPLETO, ");
			strSql.append(W83bIncidenciasVistaBD.nacta).append(", ");
			strSql.append(W83bIncidenciasVistaBD.anyoacta).append(", ");
			strSql.append(W83bIncidenciasVistaBD.versionActa).append(", ");
			strSql.append(W83bIncidenciasVistaBD.flagvalidada).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numRegDef).append(", ");
			strSql.append(W83bIncidenciasVistaBD.fechaRegDef).append(", ");
			strSql.append(W83bCentroTrabajoBD.razonSocial).append(" as ");
			strSql.append(W83bIncidenciasVistaBD.razon);
		}
		strSql.append(" FROM ").append(W83bIncidenciasVistaBD.incidenciasView);
		if(!contar){
			strSql.append(" ,").append(W83bCentroTrabajoBD.tablaCTDesa).append(" centros");
		}
		
		strSql.append(" WHERE ").append(" ").append(W83bIncidenciasVistaBD.nacta).append(" > 0");
		
		if(!contar){
			strSql.append(" and ").append(" centros.").append(W83bCentroTrabajoBD.codigoCentro);
			strSql.append("(+) = ").append(" ").append(W83bIncidenciasVistaBD.codCentro);
		}
		
		
				
		if(StringUtils.isNotEmpty(param.getTerritorioIncidenciaDesde())){
			strSql.append(" AND ");
			strSql.append(" ").append(" ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" = ?");
			params.add(Integer.valueOf(param.getTerritorioIncidenciaDesde()));
		}else{
			strSql.append(" AND ");
			strSql.append(" ").append(" (").append(W83bIncidenciasVistaBD.territorioincidencias).append(" = ?");
			strSql.append(" OR ").append(" ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" = ?");
			strSql.append(" OR ").append(" ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" = ?)");
			
			params.add(W83bClsConstantes.CONSTANTE_ALAVA);
			params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
			params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
			
		}
		String desde = param.getAnyoIncidenciaDesde();
		String hasta = param.getAnyoIncidenciaHasta();
		String numDesde = param.getNumIncidenciaDesde();
		String numHasta = param.getNumIncidenciaHasta();
		if(StringUtils.isEmpty(param.getAnyoIncidenciaDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoIncidenciaHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumIncidenciaDesde())){
			numDesde = "000000";
		}else if(6>param.getNumIncidenciaDesde().length()){
			for(int i = param.getNumIncidenciaDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumIncidenciaHasta())){
			numHasta = "999999";
		}else if(6>param.getNumIncidenciaHasta().length()){
			for(int i = param.getNumIncidenciaHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
			strSql.append(" AND ");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numincidenciaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numincidenciaCompleto).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		//fin NMERO DE INCIDENCIA
	

		desde = param.getAnyoActaDesde();
		hasta = param.getAnyoActaHasta();
		numDesde = param.getNumActaDesde();
		numHasta = param.getNumActaHasta();
		if(StringUtils.isEmpty(param.getAnyoActaDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoActaHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumActaDesde())){
			numDesde = "000000";
		}else if(6>param.getNumActaDesde().length()){
			for(int i = param.getNumActaDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumActaHasta())){
			numHasta = "999999";
		}else if(6>param.getNumActaHasta().length()){
			for(int i = param.getNumActaHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ((");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numactaCompleto).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numactaCompleto).append(" <= ?)");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));		
		strSql.append(" or (");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numactacompletoparcial).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ");				
		strSql.append(" ").append(W83bIncidenciasVistaBD.numactacompletoparcial).append(" <= ?))");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));		
		//fin NMERO DE ACTA
		
		
		//FECHA ENTRADA
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.fentrada).append(" >= to_date(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.fentrada).append(" <= to_date(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA ENTRADA
		
		
		//SOLICITANTE
		if(StringUtils.isNotEmpty(param.getTipoSolicitante())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tipsolicitante).append(" = ?");
			params.add(new Integer(param.getTipoSolicitante()));
		}		
		
		if(StringUtils.isNotEmpty(param.getDniSolicitante())){
			strSql.append(" AND upper(").append(W83bIncidenciasVistaBD.dnisolicitante).append(") = ?");
			params.add(param.getDniSolicitante().toUpperCase());
		}		
		
		if(StringUtils.isNotEmpty(param.getNombreSolicitante())){
			strSql.append(" AND upper(").append(W83bIncidenciasVistaBD.nomsolicitante).append(") like ?");
			params.add(new StringBuffer(W83bClsConstantes.UNO).append("%").append(param.getNombreSolicitante().toUpperCase()).append("%").toString());
		}		
		//fin SOLICITANTE
		if(StringUtils.isNotEmpty(param.getTipologiaIncidencia())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tipincidencia).append(" = ?");
			params.add(new Integer(param.getTipologiaIncidencia()));
		}		
		
		//TRAMITE
		if(StringUtils.isNotEmpty(param.getTramite())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tramitacion).append(" = ?");
			params.add(param.getTramite());
		}
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteDesde())){
			strSql.append(" AND (").append(W83bIncidenciasVistaBD.fecactualizacion).append(" >= to_date(?,?)");
			params.add(param.getFechaTramiteDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" OR ").append(W83bIncidenciasVistaBD.fecmodificacion).append(" >= to_date(?,?)");
			params.add(param.getFechaTramiteDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(")");
		}
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteHasta())){
			strSql.append(" AND (").append(W83bIncidenciasVistaBD.fecactualizacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" OR ").append(W83bIncidenciasVistaBD.fecmodificacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(")");
		}
		
		if(StringUtils.isNotEmpty(param.getUltimoTramite())
			&& StringUtils.isNotEmpty(param.getTramite())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.maxtramite).append(" = ?");
			params.add(param.getTramite());
		}
		
		//fin TRAMITE
		if(StringUtils.isNotEmpty(param.getFlagBusqNoValidada())
				||StringUtils.isNotEmpty(param.getFlagBusqValidada())
				||StringUtils.isNotEmpty(param.getFlagBusqDescartada())){
			strSql.append(" AND (");
			boolean flagAnyadidoWhere = false;
			if(StringUtils.isNotEmpty(param.getFlagBusqNoValidada())){
				strSql.append(W83bIncidenciasVistaBD.flagvalidada).append(" = ?");
				params.add(param.getFlagBusqNoValidada());
				flagAnyadidoWhere = true;
			}
			if(StringUtils.isNotEmpty(param.getFlagBusqValidada())){
				if(flagAnyadidoWhere){
					strSql.append(" OR ");					
				}
				strSql.append(W83bIncidenciasVistaBD.flagvalidada).append(" = ?");
				params.add(param.getFlagBusqValidada());
				flagAnyadidoWhere = true;
			}
			if(StringUtils.isNotEmpty(param.getFlagBusqDescartada())){
				if(flagAnyadidoWhere){
					strSql.append(" OR ");					
				}
				strSql.append(W83bIncidenciasVistaBD.flagvalidada).append(" = ?");
				params.add(param.getFlagBusqDescartada());
			}
			strSql.append(") ");
		}	
		
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals(""))
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());	
		
		if(contar){
			return W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		}else{			
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciasBean.class,param.getUsuarioBean(), param.getIdioma());
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String contarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT COUNT(");
		strSql.append(W83bIncidenciasVistaBD.nacta).append(") ");
				
		strSql.append(" FROM ").append(W83bIncidenciasVistaBD.incidenciasView);
		
		strSql.append(" WHERE ").append(" ").append(W83bIncidenciasVistaBD.nacta).append(" > 0");
		
		//NMERO DE INCIDENCIA
		if(StringUtils.isNotEmpty(param.getTerritorioIncidenciaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" >= ?");
			params.add(new Integer(param.getTerritorioIncidenciaDesde()));
		}
		if(StringUtils.isNotEmpty(param.getAnyoIncidenciaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.anyoincidencias).append(" >= ?");
			params.add(new Integer(param.getAnyoIncidenciaDesde()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorioIncidenciaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" <= ?");
			params.add(new Integer(param.getTerritorioIncidenciaHasta()));
		}
		if(StringUtils.isNotEmpty(param.getNumIncidenciaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.numincidencia).append(" >= ?");
			params.add(new Integer(param.getNumIncidenciaDesde()));
		}			
		if(StringUtils.isNotEmpty(param.getAnyoIncidenciaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.anyoincidencias).append(" <= ?");
			params.add(new Integer(param.getAnyoIncidenciaHasta()));
		}			
		if(StringUtils.isNotEmpty(param.getNumIncidenciaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.numincidencia).append(" <= ?");
			params.add(new Integer(param.getNumIncidenciaHasta()));
		}		
		//fin NMERO DE INCIDENCIA
		
		//NMERO DE ACTA
		if(StringUtils.isNotEmpty(param.getTerritorioActaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" <= ?");
			params.add(new Integer(param.getTerritorioActaHasta()));
		} 
		if(StringUtils.isNotEmpty(param.getTerritorioActaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" >= ?");
			params.add(new Integer(param.getTerritorioActaDesde()));
		}	
		if(StringUtils.isNotEmpty(param.getAnyoActaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.anyoacta).append(" >= ?");
			params.add(new Integer(param.getAnyoActaDesde()));
		}		
		
		
		if(StringUtils.isNotEmpty(param.getAnyoActaHasta())){
			
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.anyoacta).append(" <= ?");
			
			params.add(new Integer(param.getAnyoActaHasta()));
		}	
		
		if(StringUtils.isNotEmpty(param.getNumActaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.nacta).append(" >= ?");
		
			params.add(new Integer(param.getNumActaDesde()));
		}	
		
		if(StringUtils.isNotEmpty(param.getNumActaHasta())){
		
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.nacta).append(" <= ?");
			
			params.add(new Integer(param.getNumActaHasta()));
		}
		//fin NMERO DE ACTA
		
		
		//FECHA ENTRADA
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.fentrada).append(" >= to_date(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}	
		
		if(StringUtils.isNotEmpty(param.getFechaEntradaDesde())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.fentrada).append(" <= to_date(?,?)");
			params.add(param.getFechaEntradaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}				
			
		//fin FECHA ENTRADA
		
		
		//SOLICITANTE
		if(StringUtils.isNotEmpty(param.getDniSolicitante())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.dnisolicitante).append(" = ?");
			params.add(param.getDniSolicitante());
		}		
		
		if(StringUtils.isNotEmpty(param.getTipoSolicitante())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tipsolicitante).append(" = ?");
			params.add(new Integer(param.getTipoSolicitante()));
		}		
		
		if(StringUtils.isNotEmpty(param.getNombreSolicitante())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.nomsolicitante).append(" = ?");
			params.add(param.getNombreSolicitante());
		}		
		//fin SOLICITANTE
		
		if(StringUtils.isNotEmpty(param.getTipologiaIncidencia())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tipincidencia).append(" = ?");
			params.add(new Integer(param.getTipologiaIncidencia()));
		}		
		
		//TRAMITE
		
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteDesde())){
			strSql.append(" AND (").append(W83bIncidenciasVistaBD.fecactualizacion).append(" >= ?");
			params.add(param.getFechaTramiteDesde());
			strSql.append(" OR ").append(W83bIncidenciasVistaBD.fecmodificacion).append(" >= ?");
			params.add(param.getFechaTramiteDesde());
			strSql.append(")");
		}
		
		if(StringUtils.isNotEmpty(param.getTramite())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.tramitacion).append(" = ?");
			params.add(param.getTramite());
		}
		
		if(StringUtils.isNotEmpty(param.getUltimoTramite())){
			strSql.append(" AND ").append(W83bIncidenciasVistaBD.maxtramite).append(" = ?");
			params.add(param.getTramite());
		}
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteHasta())){
			strSql.append(" AND (").append(W83bIncidenciasVistaBD.fecactualizacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" OR ").append(W83bIncidenciasVistaBD.fecmodificacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(")");
		}
		//fin TRAMITE
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaActas.get(0).toString();	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#cargaTiposDocumentoIncidencias(java.util.HashMap)
	 */
	public List cargaTiposDocumentoIncidencias(HashMap param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//obtengo los documentos
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bTiposDocumentosVistaBD.fase);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.tramite);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.tipoDocFasTram);
		strSql.append(",");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.get("strIdioma"))){
			strSql.append(W83bTiposDocumentosVistaBD.descTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.descFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.descTipoDoc).append(" AS DESCRIPCION ");
		}else{
			strSql.append(W83bTiposDocumentosVistaBD.deseTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.deseFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.deseTipoDoc).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ");
		strSql.append(W83bTiposDocumentosVistaBD.vista);
		strSql.append(" WHERE (");
		strSql.append(W83bTiposDocumentosVistaBD.tramite).append(" = ?");
		strSql.append(" OR ").append(W83bTiposDocumentosVistaBD.tramite).append(" = ?)");
		strSql.append(" AND ");
		strSql.append(W83bTiposDocumentosVistaBD.fase).append(" = ?");
		strSql.append(" ORDER BY DESCRIPCION");
		List listaTiposDocsAux=null;
		List listaTiposDocsResult=new ArrayList();
		
		if(((String)param.get("modoAcceso")).equals(W83bClsConstantes.MODO_ALTA)){
			params.add(W83bClsConstantes.TRAMITE_INCIDENCIA_RECEPCION);
		}
		else{
			params.add(W83bClsConstantes.TRAMITE_INCIDENCIA_MODIFICACION_ACTA);
		}
		params.add(W83bClsConstantes.TRAMITE_SINESPECIFICAR);
		
		params.add(W83bClsConstantes.FASE_INCIDENCIAS);
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bTipoDocumentoBean.class,null, "actas");
		for (int j=0;j<listaTiposDocsAux.size();j++)
		{
			listaTiposDocsResult.add(listaTiposDocsAux.get(j));
		}
		params.clear();
		
		return listaTiposDocsResult;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaTerritorio).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaAnyo).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaNum).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.versionacta).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.codColegio).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.colegio_cast).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.colegio_eusk).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.dniDelegado).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.primerApellidoDelegado).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.segundoApellidoDelegado).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.sexoDelegado).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.nombreDelegado).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.codSindicato).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.sindicato_cast).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.sindicato_eusk).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.siglas).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bDelegadosIncidenciasVistaBD.fechaAlta).append(",?) AS ").append(W83bDelegadosIncidenciasVistaBD.fechaAlta);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append("TO_CHAR(");
		strSql.append(W83bDelegadosIncidenciasVistaBD.fechaBaja).append(",?) AS ").append(W83bDelegadosIncidenciasVistaBD.fechaBaja);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bDelegadosIncidenciasVistaBD.codBaja).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.baja_cast).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.baja_Eusk).append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.usuario).append(", TO_CHAR(");
		strSql.append(W83bDelegadosIncidenciasVistaBD.fActu).append(",?) AS ").append(W83bDelegadosIncidenciasVistaBD.fActu);
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		strSql.append(", ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.dniSustituto);
		strSql.append(" FROM ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.delegadosIncidenciasVista);
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaTerritorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaAnyo).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaNum).append(" = ? ");
		params.add(param.getActaTerritorio());
		params.add(param.getActaAnyo());
		params.add(param.getActaNumero());
		strSql.append(" AND (");
		strSql.append(W83bDelegadosIncidenciasVistaBD.validada).append(" = ? ");
		strSql.append(" or ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.validada).append(" = ? )");
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		strSql.append(" AND ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.versionacta).append(" = (");
		strSql.append("SELECT max(vista.");
		strSql.append(W83bDelegadosIncidenciasVistaBD.versionacta).append(") ");
		strSql.append(" FROM ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.delegadosIncidenciasVista);
		strSql.append(" vista WHERE ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaTerritorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaAnyo).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.actaNum).append(" = ? ");
		params.add(param.getActaTerritorio());
		params.add(param.getActaAnyo());
		params.add(param.getActaNumero());
		strSql.append(" AND (");
		strSql.append(W83bDelegadosIncidenciasVistaBD.validada).append(" = ? ");
		strSql.append(" or ");
		strSql.append(W83bDelegadosIncidenciasVistaBD.validada).append(" = ? )");
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		strSql.append(") ");
		
		
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals(""))
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());	
		//fin MOTIVOS BAJA
		List listaDelegados = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,param.getUsuarioBean(), param.getIdioma());
		
		return listaDelegados;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List buscarDelegadoIncidencias(w83b.w83bBeans.W83bDelegadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.acta).append(", ");
		strSql.append(W83bDelegadosBD.anyoActa).append(", ");
		strSql.append(W83bDelegadosBD.apellido1).append(", ");
		strSql.append(W83bDelegadosBD.apellido2).append(", ");
		strSql.append(W83bDelegadosBD.baja).append(", ");
		strSql.append(W83bDelegadosBD.codColegio).append(", ");
		strSql.append(W83bDelegadosBD.codSindicato).append(", ");
		strSql.append(W83bDelegadosBD.dni).append(", ");
		strSql.append(W83bDelegadosBD.dniSustituto).append(", to_char(");
		strSql.append(W83bDelegadosBD.fechaAlta).append(",?) AS ").append(W83bDelegadosBD.fechaAlta);
		strSql.append(", to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bDelegadosBD.fechaBaja).append(",?), to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bDelegadosBD.fechaMod).append(",?) AS ").append(W83bDelegadosBD.fechaMod);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		strSql.append(W83bDelegadosBD.nombre).append(", ");
		strSql.append(W83bDelegadosBD.sexo).append(", ");
		strSql.append(W83bDelegadosBD.territorioActa).append(", ");
		strSql.append(W83bDelegadosBD.usuario).append(", ");
		strSql.append(W83bDelegadosBD.versionActa);
		
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
		
		strSql.append(" WHERE ").append(W83bDelegadosBD.dni).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.fechaBaja).append(" IS NULL ");
		params.add(param.getDniDelegado());		
		params.add(param.getActaTerritorio());		
		params.add(new Integer(param.getActaAnyo()));		
		params.add(new Integer(param.getActaNum()));		
		params.add(param.getActaVersion());		
		
		
		List listaDelegados = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,null, "delegado");
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return listaDelegados;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarHistorialTramitacionIncidencias(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public java.util.List buscarHistorialTramitacionIncidencias(String actaTerritorio, String actaAnyo, String actaNum, String version, String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.hisTram_anyoActa).append(", ");
		strSql.append(W83bActasBD.hisTram_numActa).append(", ");
		strSql.append(W83bActasBD.hisTram_territActa).append(", ");
		strSql.append(W83bActasBD.hisTram_versionActa).append(", ");
		strSql.append(W83bActasBD.hisTram_tram).append(", ");
		strSql.append(W83bActasBD.hisTram_fase).append(", to_char(");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion).append(",?) as ").append(W83bActasBD.hisTram_fechaActualizacion).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(idioma));
		strSql.append(W83bActasBD.hisTram_usuario).append(", ");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion).append(", to_char(");
		strSql.append(W83bActasBD.hisTram_fechaModificacion).append(",?) as ").append(W83bActasBD.hisTram_fechaModificacion).append(", to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.hisTram_fechaRegSal).append(",?) as ").append(W83bActasBD.hisTram_fechaModificacion).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.hisTram_numRegSal).append(", to_char( ");
		strSql.append(W83bActasBD.hisTram_fechaNotif).append(",?)  as ").append(W83bActasBD.hisTram_fechaNotif).append(", to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.hisTram_fechaExpir).append(",?) as ").append(W83bActasBD.hisTram_fechaExpir).append(", to_char( ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.hisTram_fechaTram).append(",?)  as ").append(W83bActasBD.hisTram_fechaTram);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.hisTram_territActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.hisTram_anyoActa).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.hisTram_numActa).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.hisTram_versionActa).append(" = ? ");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(version);
		
		
		List listaHistorialTramitacion = W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciaHistorialActaBean.class,null, idioma);
		
		return listaHistorialTramitacion;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerImpugnaciones(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List obtenerImpugnaciones(String actaTerritorio, String actaAnyo, String actaNum, String version, String idioma)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		
		strSql.append(W83bImpugnacionesBD.ano_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.c_territ).append(",to_char( ");
		strSql.append(W83bImpugnacionesBD.f_impug).append(",?)  as ").append(W83bImpugnacionesBD.f_impug).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bImpugnacionesBD.n_preaviso).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_preaviso).append(", ");
		strSql.append(W83bImpugnacionesBD.n_acta).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_acta).append(", ");
		strSql.append(W83bImpugnacionesBD.version).append(", ");
		strSql.append(W83bImpugnacionesBD.dniArbitro).append(", ");
		strSql.append(W83bImpugnacionesBD.c_impug).append(",to_char(  ");
		strSql.append(W83bImpugnacionesBD.fenvarb).append(",?)  as ").append(W83bImpugnacionesBD.fenvarb).append(",to_char(  ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bImpugnacionesBD.fdeses).append(",?)  as ").append(W83bImpugnacionesBD.fdeses).append(",to_char(  ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bImpugnacionesBD.fenvjuz).append(",?)  as ").append(W83bImpugnacionesBD.fenvjuz).append(",to_char(  ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));

		strSql.append(W83bImpugnacionesBD.fsenten).append(",?)  as ").append(W83bImpugnacionesBD.fsenten).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bImpugnacionesBD.asunto).append(", ");
		strSql.append(W83bImpugnacionesBD.decision).append(", ");
		strSql.append(W83bImpugnacionesBD.usuario).append(",to_char(  ");
		strSql.append(W83bImpugnacionesBD.factu).append(",?)  as ").append(W83bImpugnacionesBD.factu).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bImpugnacionesBD.nregistro).append(",to_char(  ");
		strSql.append(W83bImpugnacionesBD.fregistro).append(",?)  as ").append(W83bImpugnacionesBD.fregistro).append("");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
	
		strSql.append(" FROM ").append(W83bImpugnacionesBD.tableImpugnaciones);

		strSql.append(" where ").append(W83bImpugnacionesBD.c_territ).append(" = ?");
		strSql.append(" AND ").append(W83bImpugnacionesBD.n_acta).append(" = ?");
		strSql.append(" AND ").append(W83bImpugnacionesBD.ano_acta).append(" = ?");
		//strSql.append(" AND ").append(W83bImpugnacionesBD.version).append(" = ?");
		
		params.add(actaTerritorio);
		params.add(actaNum);
		params.add(actaAnyo);
		//params.add(version);
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciaImpugnacionBean.class,null, null);
		

	}
	
	/**
	 * No existe dni delegados.
	 *
	 * @param territorioActa the territorio acta
	 * @param anyoActa the anyo acta
	 * @param numActa the num acta
	 * @param dniDelegado the dni delegado
	 * @param usuario the usuario
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean noExisteDniDelegados(String territorioActa, String anyoActa,String numActa, String dniDelegado,W83bUsuarioXLNetsBean usuario,String fechaEntrada) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuario.getIdUsuario());
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.dni);
		
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
		
		strSql.append(" WHERE ").append(W83bDelegadosBD.dni).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ");
		strSql.append("(SELECT MAX(");
		strSql.append(W83bDelegadosBD.versionActa);
		strSql.append(") FROM ").append(W83bDelegadosBD.delegadosVista);
		strSql.append(", ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.territorioActa).append(" =  ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append(" AND ");
		strSql.append(W83bDelegadosBD.anyoActa).append(" =  ");
		strSql.append(W83bActasBD.anyoActa);
		strSql.append(" AND ");
		strSql.append(W83bDelegadosBD.acta).append(" =  ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" AND ");
		strSql.append(W83bDelegadosBD.versionActa).append(" =  ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.validada).append(" <> ? ");
		strSql.append(" AND ");
		strSql.append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ?)");
		if(null==fechaEntrada){
			strSql.append(" AND ").append(W83bDelegadosBD.fechaBaja).append(" IS NULL ");
		}else{
			strSql.append(" AND ").append(W83bDelegadosBD.fechaAlta).append(" = to_date(?,?) ");			
		}
		
		params.add(dniDelegado.toUpperCase());		
		params.add(territorioActa);		
		params.add(new Integer(anyoActa));		
		params.add(new Integer(numActa));			
		params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);		
		params.add(territorioActa);		
		params.add(new Integer(anyoActa));		
		params.add(new Integer(numActa));		
		if(null!=fechaEntrada){
			params.add(fechaEntrada);		
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(usuario.getIdioma()));
		}
		
		List listaDnis = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		if(listaDnis.size()>0){
			return true;
		}
		
		return false;		
	}
	
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaVersion()));		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return true;
		}
		
		return false;		
	}
	
		/**
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public String columnaNuevaT16(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.nueva);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" = ? ");
		params.add(new Integer(incidencia.getActaVersion()));		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return (listaIncidencias.get(0)).toString();
		}
		
		return "0";		
	}
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" = 0 ");
		
		strSql.append(" AND (").append(W83bIncidenciasBD.ANO_INCID_061).append(" < ? or (");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? and ");
		strSql.append(W83bIncidenciasBD.N_INCID_061).append(" < ?)) ");
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaNumero());		
		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaAnteriorPorVersion(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" = 0 ");
		
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" <= ?");
		params.add(incidencia.getActaVersion());		
		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public List existeActaIncidenciaNoValidadaAnteriorReturnNIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" = 0 ");
		
		strSql.append(" AND (").append(W83bIncidenciasBD.ANO_INCID_061).append(" < ? or (");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? and ");
		strSql.append(W83bIncidenciasBD.N_INCID_061).append(" < ?)) ");
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaNumero());		
		
		
		
		List listaIncidencias = W83bDataBase.executeQuery(strSql.toString(),params,null);

		
		return listaIncidencias;		
	}
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaPosterior(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" = 0 ");
		
		strSql.append(" AND (").append(W83bIncidenciasBD.ANO_INCID_061).append(" > ? or (");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? and ");
		strSql.append(W83bIncidenciasBD.N_INCID_061).append(" > ?)) ");
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaAnyo());		
		params.add(incidencia.getIncidenciaNumero());		
		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaEntradaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TO_CHAR(");
		strSql.append(W83bActasBD.fechaEleccion);
		
		strSql.append(",?) FROM ").append(W83bActasBD.actasTable);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma()));
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" = ?");
		params.add(incidencia.getActaTerritorio());		
		params.add(new Integer(incidencia.getActaAnyo()));		
		params.add(new Integer(incidencia.getActaNumero()));		
		params.add(new Integer(incidencia.getActaVersion()));	
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaEntradaIncidenciaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TO_CHAR(");
		strSql.append(W83bIncidenciasBD.F_ENTRADA_061);
		
		strSql.append(",?) FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma()));
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" = ?");
		params.add(incidencia.getActaTerritorio());		
		params.add(new Integer(incidencia.getActaAnyo()));		
		params.add(new Integer(incidencia.getActaNumero()));		
		params.add(new Integer(incidencia.getActaVersion()));	
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias&&0<listaIncidencias.size()&&null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaEntradaIncidenciaPosterior(W83bNuevaIncidenciasBean incidencia,String version) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TO_CHAR(");
		strSql.append(W83bIncidenciasBD.F_ENTRADA_061);
		
		strSql.append(",?) FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma()));
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" > ?");
		params.add(incidencia.getActaTerritorio());		
		params.add(new Integer(incidencia.getActaAnyo()));		
		params.add(new Integer(incidencia.getActaNumero()));		
		params.add(new Integer(version));	
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" <> ?");
		params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);	
		strSql.append(" ORDER BY ").append(W83bIncidenciasBD.VERSION_ACTA_061);
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias&&0<listaIncidencias.size()&&null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public boolean existeIncidenciaPosteriorNoValidada(W83bIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" > ?");
		params.add(incidencia.getTerritorioActa());		
		params.add(new Integer(incidencia.getAnyoActa()));		
		params.add(new Integer(incidencia.getNumActaSencillo()));		
		params.add(new Integer(incidencia.getVersionActa()));	
		strSql.append(" AND ").append(W83bIncidenciasBD.VALIDADA_061).append(" = ?");
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);	
		strSql.append(" ORDER BY ").append(W83bIncidenciasBD.VERSION_ACTA_061);
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return (null!=listaIncidencias&&0<listaIncidencias.size());
	}
	
	/**
	 * Validar fecha validacin incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaValidacionIncidenciaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TO_CHAR(");
		strSql.append(W83bIncidenciasBD.F_VALIDAC_061);
		
		strSql.append(",?) FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma()));
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_ACTA_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.VERSION_ACTA_061).append(" = ?");
		params.add(incidencia.getActaTerritorio());		
		params.add(new Integer(incidencia.getActaAnyo()));		
		params.add(new Integer(incidencia.getActaNumero()));		
		params.add(new Integer(incidencia.getActaVersion()));	
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias&&0<listaIncidencias.size()&&null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/**
	 * Validar fecha validacin incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaValidacionIncidenciaAnteriorNIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TO_CHAR(");
		strSql.append(W83bIncidenciasBD.F_VALIDAC_061);
		
		strSql.append(",?) FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(incidencia.getIdioma()));
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_INCID_061).append(" = ?");
		params.add(incidencia.getIncidenciaTerritorio());		
		params.add(new Integer(incidencia.getIncidenciaAnyo()));		
		params.add(new Integer(incidencia.getIncidenciaNumero()));		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias&&0<listaIncidencias.size()&&null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/**
	 * Existe acta tabla actas.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public List existeActaTablaActas(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.numRegDefinitivo);
		strSql.append(", LPAD(");
		strSql.append(W83bActasBD.numTotalActa);
		strSql.append(",6,'0') as ").append(W83bActasBD.numTotalActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.anyoTotalActa);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append(" = ? ");
		params.add(new Integer(incidencia.getActaAnyo()));		
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ? ");
		params.add(new Integer(incidencia.getActaNumero()));		
		strSql.append(" AND ").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(incidencia.getActaTerritorio());		
		/*strSql.append(" AND ");
//		strSql.append("(");
		
		strSql.append("(").append(W83bActasBD.numRegDefinitivo).append(" is not null ");
		strSql.append(" AND ").append(W83bActasBD.fecRegDefinitivo).append(" is not null) ");*/
//		strSql.append(" OR (").append(W83bActasBD.numTotalActa).append(" is not null)) ");
		strSql.append(" order by ").append(W83bActasBD.versionActa).append(" desc");
		
		
		List listaIncidencias = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
			return listaIncidencias;
	}
	
	/**
	 * Existe incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? ");
		params.add(new Integer(incidencia.getIncidenciaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_INCID_061).append(" = ? ");
		params.add(new Integer(incidencia.getIncidenciaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(incidencia.getIncidenciaTerritorio());		
		
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaIncidencias.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxIncidencia(String anyo,String territorio)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		
		strSql.append(") FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ?");
		params.add(territorio);
		params.add(anyo);
		
		List listaIncidencias = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaIncidencias.get(0)){
			respuesta = listaIncidencias.get(0).toString();
		}else{
			respuesta = "0";
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidencia(String actaTerritorio, String actaAnyo, String actaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaValidadaNoValidadaDescartada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String versionIncidencia(String incidenciaTerritorio, String incidenciaAnyo, String incidenciaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.VERSION_ACTA_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.N_INCID_061).append(" = ?");
		params.add(incidenciaTerritorio);
		params.add(incidenciaAnyo);
		params.add(incidenciaNum);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(0!=listaActas.size()&&
				null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaNoValidado(String actaTerritorio, String actaAnyo, String actaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaValidada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaValidadaNoValidada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaValidadaNoValidadaNoActual(String actaTerritorio, String actaAnyo, String actaNum,String version)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" <> ?");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		params.add(version);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(0!=listaActas.size()&&
				null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxVersionIncidenciaAnteriorValidadaNoValidadaNoActual(String actaTerritorio, String actaAnyo, String actaNum,String version)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" AND (").append(W83bActasBD.validada).append(" = ?");
		strSql.append(" OR ").append(W83bActasBD.validada).append(" = ?)");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" is null");
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" < ?");
		params.add(actaTerritorio);
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		params.add(version);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "";
		
		if(0!=listaActas.size()&&
				null!=listaActas.get(0)){
			respuesta = listaActas.get(0).toString();
		}else{
			respuesta = null;
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#encontrarDiferenciasActa(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public java.util.List encontrarDiferenciasActa(String actaTerritorio, String actaAnyo, String actaNum, String version,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bDiferenciasBD.codSind).append(",");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(",");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(",");
		strSql.append(W83bDiferenciasBD.anyoActa).append(",");
		strSql.append(W83bDiferenciasBD.acta).append(",");
		strSql.append(W83bDiferenciasBD.territorioActa).append(",");
		strSql.append(W83bDiferenciasBD.versionActa).append(",");
		strSql.append(W83bDiferenciasBD.usuario).append(",");
		strSql.append("TO_CHAR(");
		strSql.append(W83bDiferenciasBD.fecha).append(",?) AS ").append(W83bDiferenciasBD.fecha);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ").append(W83bDiferenciasBD.difTable).append(" DIF ");
		strSql.append(" WHERE DIF.").append(W83bDiferenciasBD.acta).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.anyoActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.territorioActa).append(" = ? ").append(" AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.versionActa).append(" = ? ");
		params.add(actaNum);
		params.add(actaAnyo);
		params.add(actaTerritorio);
		params.add(version);
		
		List listaDiferencias=W83bDataBase.executeQuery(strSql.toString(),params,W83bListaDiferenciasBean.class,null,"incidencia");
		
		return listaDiferencias;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerDocsActas(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List obtenerDocsActas(String actaTerritorio, String actaAnyo, String actaNum, String version, String idioma) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.doc_id).append(", ");
		strSql.append(W83bActasBD.doc_numActa).append(", ");
		strSql.append(W83bActasBD.doc_anyoActa).append(", ");
		strSql.append(W83bActasBD.doc_territActa).append(", ");
		strSql.append(W83bActasBD.doc_versionActa).append(", ");
		strSql.append(W83bActasBD.doc_tram).append(", ");
		strSql.append(W83bActasBD.doc_fase).append(", ");
		strSql.append(W83bActasBD.doc_longitud).append(", ");
		strSql.append(W83bActasBD.doc_documento).append(", ");
		strSql.append(W83bActasBD.doc_nombre).append(", ");
		strSql.append(W83bActasBD.doc_tipo).append(", ");
		strSql.append(W83bActasBD.doc_numReg).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bActasBD.doc_fechaReg).append(",?) AS ").append(W83bActasBD.doc_fechaReg);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma(idioma));
		strSql.append(W83bActasBD.doc_fechaActualizacion).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bActasBD.doc_fechaActualizacion).append(",?) AS ").append(W83bActasBD.doc_fechaActualizacion);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma(idioma));
		strSql.append(W83bActasBD.doc_usuario);
		
		strSql.append(" FROM ").append(W83bActasBD.actas_docsTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.doc_territActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_numActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_versionActa).append(" = ?");
		
		params.add(actaTerritorio);		
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(version);//la version
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBeanIncidencia.class,null, "actas");
		
		return listaDocumentos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxDocsActas()
	 */
	public String maxDocsActas() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT max(");
		strSql.append(W83bActasBD.doc_id).append(") ");
		
		
		strSql.append(" FROM ").append(W83bActasBD.actas_docsTable);

		
		List listaDocActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "0";
		
		if(null!=listaDocActas.get(0)){
			respuesta = listaDocActas.get(0).toString();
		}else{
			respuesta = null;
		}	
		return respuesta;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerEscrutinio(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List obtenerEscrutinio(String actaTerritorio, String actaAnyo, String actaNum, String version,String idioma) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(", ");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(", ");
		strSql.append(W83bEscrutiniosBD.acta).append(", ");
		strSql.append(W83bEscrutiniosBD.versionActa).append(", ");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(", ");
		strSql.append(W83bEscrutiniosBD.codSind).append(", ");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(", ");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(", ");
		strSql.append(W83bEscrutiniosBD.numVotos).append(", ");
		strSql.append(W83bEscrutiniosBD.usuario).append(", ");
		strSql.append("TO_CHAR(");
		strSql.append(W83bEscrutiniosBD.fecha).append(",?) AS ").append(W83bEscrutiniosBD.fecha);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));

		
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista);
		
		strSql.append(" WHERE ").append(W83bEscrutiniosBD.territorioActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bEscrutiniosBD.acta).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bEscrutiniosBD.versionActa).append(" = ?");
		
		params.add(actaTerritorio);		
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(version);//la version
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bEscrutinioBean.class,null, "incidencia");
		
		return listaDocumentos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerPapeletas(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List obtenerPapeletas(String actaTerritorio, String actaAnyo, String actaNum, String version) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPapeletasBD.anyoActa).append(", ");
		strSql.append(W83bPapeletasBD.territorioActa).append(", ");
		strSql.append(W83bPapeletasBD.acta).append(", ");
		strSql.append(W83bPapeletasBD.versionActa).append(", ");
		strSql.append(W83bPapeletasBD.codColegio).append(", ");
		strSql.append(W83bPapeletasBD.validas).append(", ");
		strSql.append(W83bPapeletasBD.nulas).append(", ");
		strSql.append(W83bPapeletasBD.blancas).append(", ");
		strSql.append(W83bPapeletasBD.votantes).append(", ");
		strSql.append(W83bPapeletasBD.electores);
		
		strSql.append(" FROM ").append(W83bPapeletasBD.papeletasVista);
		
		strSql.append(" WHERE ").append(W83bPapeletasBD.territorioActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPapeletasBD.anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPapeletasBD.acta).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPapeletasBD.versionActa).append(" = ?");
		
		params.add(actaTerritorio);		
		params.add(actaAnyo);
		params.add(actaNum);
		params.add(version);//la version
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPapeletasBean.class,null, "incidencia");
		
		return listaDocumentos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerActas(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public W83bActasIncidenciaBean obtenerActas(String actaTerritorio, String actaAnyo, String actaNum,String actaVersion,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(",");
		strSql.append(W83bActasBD.numPreaviso).append(",");
		strSql.append(W83bActasBD.anyoPreaviso).append(",");
		strSql.append(W83bActasBD.codConvenio).append(",");
		strSql.append(W83bActasBD.codCentro).append(",");
		
		strSql.append(W83bActasBD.codMotivosBaja);
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaEntrada).append(",?) AS ").append(W83bActasBD.fechaEntrada);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaEleccion).append(",?) AS ").append(W83bActasBD.fechaEleccion);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.totaldel).append(",");
		strSql.append(W83bActasBD.totalElectores).append(",");
		strSql.append(W83bActasBD.nCandidatosHombre).append(",");
		strSql.append(W83bActasBD.nCandidatosMujer).append(",");
		strSql.append(W83bActasBD.anyoTotalActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegistro);
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaRegistro).append(",?) AS ").append(W83bActasBD.fechaRegistro);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.anyoRegDefinitivo).append(",");
		strSql.append(W83bActasBD.numRegDefinitivo);
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fecRegDefinitivo).append(",?) AS ").append(W83bActasBD.fecRegDefinitivo);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaComision).append(",?) AS ").append(W83bActasBD.fechaComision);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaRequerimiento).append(",?) AS ").append(W83bActasBD.fechaRequerimiento);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaSubsanacionReq).append(",?) AS ").append(W83bActasBD.fechaSubsanacionReq);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaRetiradaComision).append(",?) AS ").append(W83bActasBD.fechaRetiradaComision);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaPresentacionRegRegInterno).append(",?) AS ").append(W83bActasBD.fechaPresentacionRegRegInterno);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaBaja).append(",?) AS ").append(W83bActasBD.fechaBaja);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.delHombres).append(",");
		strSql.append(W83bActasBD.delMujeres).append(",");
		strSql.append(W83bActasBD.nElectoresMujer).append(",");
		strSql.append(W83bActasBD.nElectoresHombre).append(",");
		strSql.append(W83bActasBD.nElectoresMujer).append(",");
		strSql.append(W83bActasBD.marcaComision).append(",");
		strSql.append(W83bActasBD.observaciones).append(",");
		strSql.append(W83bActasBD.maxDel).append(",");
		strSql.append(W83bActasBD.usuarioActualizacion);
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.fechaActualizacion).append(",?) AS ").append(W83bActasBD.fechaActualizacion);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.inspeccionada);
		strSql.append(",TO_CHAR(");
		strSql.append(W83bActasBD.F_CONSTCOM_016).append(",?) AS ").append(W83bActasBD.F_CONSTCOM_016);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bActasBD.validada);
		strSql.append(", ");
		strSql.append(W83bActasBD.nueva);


		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append(" = ? AND ");
		strSql.append(W83bActasBD.anyoActa).append(" = ? AND ");
		strSql.append(W83bActasBD.codTerritActa).append(" = ? AND ");
		strSql.append(W83bActasBD.versionActa).append(" = ?");
		params.add(actaNum);
		params.add(actaAnyo);
		params.add(actaTerritorio);//total
		params.add(actaVersion);//c1
		
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bActasIncidenciaBean.class,null, "DETALLE");
		
		return (W83bActasIncidenciaBean)listaActas.get(0);		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#obtenerActas(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public HashMap obtenerActasCodCentro(String actaTerritorio, String actaAnyo, String actaNum,String actaVersion,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(",");
		strSql.append(W83bActasBD.codCentro);	
		
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append(" = ? AND ");
		strSql.append(W83bActasBD.anyoActa).append(" = ? AND ");
		strSql.append(W83bActasBD.codTerritActa).append(" = ? AND ");
		strSql.append(W83bActasBD.versionActa).append(" = ?");
		params.add(actaNum);
		params.add(actaAnyo);
		params.add(actaTerritorio);//total
		params.add(actaVersion);//c1
		
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return (HashMap)listaActas.get(0);		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String anyadirIncidencia(W83bNuevaIncidenciasBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append("(");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.TP_INCIDENCIA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.TP_SOLICIT_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.N_ACTA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.ANO_ACTA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.VERSION_ACTA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.VALIDADA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.F_ENTRADA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.F_REGISTRO_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.N_REG_ENT_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.DNI_SOLIC_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.RZ_SOCIAL_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.OBSERVACIONES_061);
		if(StringUtils.isNotEmpty(param.getActaParcial())){
			strSql.append(", ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_PARCIAL_061);			
			strSql.append(", ");
			strSql.append(W83bIncidenciasBD.N_ACTA_PARCIAL_061);
		}
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?");
		if(StringUtils.isNotEmpty(param.getFecEntrada())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		if(StringUtils.isNotEmpty(param.getFecRegistro())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		if(StringUtils.isNotEmpty(param.getActaParcial())){
			strSql.append(",?,?,?,?,?,?)");
		}else{
			strSql.append(",?,?,?,?)");
		}
		
		params.add(new Integer(param.getIncidenciaNumero()));
		params.add(new Integer(param.getIncidenciaAnyo()));
		params.add(param.getIncidenciaTerritorio().toUpperCase());
		params.add(param.getTipologiaIncidencia().toUpperCase());
		if(StringUtils.isNotEmpty(param.getTipoSolicitante())){
			params.add(new Integer(param.getTipoSolicitante()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		params.add(new Integer(param.getActaNumero()));
		params.add(new Integer(param.getActaAnyo()));
		params.add(new Integer(param.getActaVersion()));
		if(StringUtils.isNotEmpty(param.getValidada())){
			params.add(param.getValidada().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getFecEntrada())){
			params.add(param.getFecEntrada());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getFecRegistro())){
			params.add(param.getFecRegistro());
			params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getNumRegistroES())){
			params.add(param.getNumRegistroES());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		if(StringUtils.isNotEmpty(param.getDniSolicitante())){
			params.add(param.getDniSolicitante().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getNombreSolicitante())){
			params.add(param.getNombreSolicitante().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getObservaciones())){
			params.add(param.getObservaciones().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getActaParcial())){
			params.add(param.getActaParcial().substring(0, 4));			
			params.add(param.getActaParcial().substring(4));			
		}

		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
	
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarIncidencia(W83bNuevaIncidenciasBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" SET ");
		strSql.append(W83bIncidenciasBD.VALIDADA_061);
		strSql.append(" = ? ");
		if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(param.getValidada())){
			strSql.append(", ");
			strSql.append(W83bIncidenciasBD.F_VALIDAC_061);
			strSql.append(" = to_date(?,?) ");
		}
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.OBSERVACIONES_061);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.DNI_SOLIC_061);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.RZ_SOCIAL_061);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.TP_SOLICIT_061);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.F_ENTRADA_061);
		strSql.append(" = to_date(?,?) ");
//		if(StringUtils.isNotEmpty(param.getFecRegistro())){
			strSql.append(", ");
			strSql.append(W83bIncidenciasBD.F_REGISTRO_061);
			strSql.append(" = to_date(?,?) ");
			strSql.append(", ");
			strSql.append(W83bIncidenciasBD.N_REG_ENT_061);
			strSql.append(" = ? ");
//		}
		
		if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(param.getValidada())){
			params.add(param.getValidada());
		}else if(W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(param.getValidada())){
			params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);			
		}else if(W83bClsConstantes.CONSTANTE_DESCARTADA.equals(param.getValidada())){
			params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);			
		}
		if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(param.getValidada())){
			params.add(param.getFecValidacion());			
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getObservaciones())){
			params.add(param.getObservaciones());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getDniSolicitante())){
			params.add(param.getDniSolicitante());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getNombreSolicitante())){
			params.add(param.getNombreSolicitante().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getTipoSolicitante())){
			params.add(param.getTipoSolicitante());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		params.add(param.getFecEntrada());		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFecRegistro())){
			params.add(param.getFecRegistro());		
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(param.getNumRegistroES());
		}else{
			params.add(W83bClsConstantes.NULL_DATE);		
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? ");
		params.add(new Integer(param.getIncidenciaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_INCID_061).append(" = ? ");
		params.add(new Integer(param.getIncidenciaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(param.getIncidenciaTerritorio());		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarIncidenciaSimple(W83bNuevaIncidenciasBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" SET ");
		strSql.append(W83bIncidenciasBD.VALIDADA_061);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.F_VALIDAC_061);
		strSql.append(" = to_date(?,?) ");
		
		params.add(W83bClsConstantes.CONSTANTE_VALIDADA);			
		params.add(param.getFecValidacion());			
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" WHERE ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ? ");
		params.add(new Integer(param.getIncidenciaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.N_INCID_061).append(" = ? ");
		params.add(new Integer(param.getIncidenciaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ? ");
		params.add(param.getIncidenciaTerritorio());		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarActaNDelegadosTotales(W83bActasIncidenciaBean acta)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ").append(W83bActasBD.actasTable);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.totaldel);
		strSql.append(" = ? ");
		params.add(new Integer(acta.getTotalTrabajadores()));		
		strSql.append(", ");
		strSql.append(W83bActasBD.delHombres);
		strSql.append(" = ? ");
		params.add(new Integer(acta.getNTrabHombre()));		
		strSql.append(", ");
		strSql.append(W83bActasBD.delMujeres);
		strSql.append(" = ? ");
		params.add(new Integer(acta.getNTrabMujer()));		
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append(" = ? ");
		params.add(new Integer(acta.getAnyoActa()));		
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ? ");
		params.add(new Integer(acta.getNumActa()));		
		strSql.append(" AND ").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(acta.getCodTerritActa());		
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" = ? ");
		params.add(new Integer(acta.getVersionActa()));		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarActaValidada(W83bNuevaIncidenciasBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ").append(W83bActasBD.actasTable);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.validada);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bActasBD.fechaActualizacion);
		if(StringUtils.isEmpty(param.getFecValidacion())){
			strSql.append(" = SYSDATE ");
		}else{
			strSql.append(" = to_Date(?,?) ");
		}
		
		params.add(param.getValidada());
		if(StringUtils.isNotEmpty(param.getFecValidacion())){
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFecValidacion(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
		}
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append(" = ? ");
		params.add(new Integer(param.getActaAnyo()));		
		strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ? ");
		params.add(new Integer(param.getActaNumero()));		
		strSql.append(" AND ").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(param.getActaTerritorio());		
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" = ? ");
		params.add(new Integer(param.getActaVersion()));		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String actualizarImpugnacionIncidencia(W83bIncidenciaImpugnacionBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ").append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append(" SET ");
		strSql.append(W83bImpugnacionesBD.version);
		strSql.append(" = ? ");
		
		params.add(new Integer(param.getVersion()));
		
		strSql.append(" WHERE ").append(W83bImpugnacionesBD.ano_acta).append(" = ? ");
		params.add(new Integer(param.getAnoActa()));		
		strSql.append(" AND ").append(W83bImpugnacionesBD.n_acta).append(" = ? ");
		params.add(new Integer(param.getNActa()));		
		strSql.append(" AND ").append(W83bImpugnacionesBD.c_territ).append(" = ? ");
		params.add(param.getCodTerritorioImpugnacion());		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		return "0";
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public String anyadirImpugnacionIncidencia(W83bIncidenciaImpugnacionBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append("(");
		strSql.append(W83bImpugnacionesBD.ano_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.c_territ).append(", ");
		strSql.append(W83bImpugnacionesBD.f_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.n_preaviso).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_preaviso).append(", ");
		strSql.append(W83bImpugnacionesBD.n_acta).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_acta).append(", ");
		strSql.append(W83bImpugnacionesBD.version).append(", ");
		strSql.append(W83bImpugnacionesBD.dniArbitro).append(", ");
		strSql.append(W83bImpugnacionesBD.c_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.fenvarb).append(", ");
		strSql.append(W83bImpugnacionesBD.fdeses).append(", ");
		strSql.append(W83bImpugnacionesBD.fenvjuz).append(", ");

		strSql.append(W83bImpugnacionesBD.fsenten).append(", ");
		strSql.append(W83bImpugnacionesBD.asunto).append(", ");
		strSql.append(W83bImpugnacionesBD.decision).append(", ");
		strSql.append(W83bImpugnacionesBD.usuario).append(", ");
		strSql.append(W83bImpugnacionesBD.factu).append(", ");
		strSql.append(W83bImpugnacionesBD.nregistro).append(", ");
		strSql.append(W83bImpugnacionesBD.fregistro);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?");
		
		if(StringUtils.isNotEmpty(param.getFechaImpugnacion())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		
		strSql.append(",?,?,?,?,?,?,?");
		if(StringUtils.isNotEmpty(param.getFenvarb())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		if(StringUtils.isNotEmpty(param.getFdeses())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		if(StringUtils.isNotEmpty(param.getFenvjuz())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}

		if(StringUtils.isNotEmpty(param.getFsenten())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		strSql.append(",?,?,?");
		strSql.append(",to_date(?,?)");			
		strSql.append(",?");
		if(StringUtils.isNotEmpty(param.getFregistro())){
			strSql.append(",to_date(?,?))");
		}else{
			strSql.append(",?)");			
		}
		
		params.add(new Integer(param.getAnoImpugnacion()));
		params.add(new Integer(param.getNumImpugnacion()));
		params.add(param.getCodTerritorioImpugnacion());
		if(StringUtils.isNotEmpty(param.getFechaImpugnacion())){
			params.add(param.getFechaImpugnacion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getNPreaviso())){
			params.add(param.getNPreaviso());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getAnoPreaviso())){
			params.add(param.getAnoPreaviso());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getNActa())){
			params.add(param.getNActa());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getAnoActa())){
			params.add(param.getAnoActa());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getVersion())){
			params.add(param.getVersion());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getDniArbitro())){
			params.add(param.getDniArbitro());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(param.getCodImpugnaciones())){
			params.add(param.getCodImpugnaciones());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(param.getFenvarb())){
			params.add(param.getFenvarb());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getFdeses())){
			params.add(param.getFdeses());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getFenvjuz())){
			params.add(param.getFenvjuz());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}

		if(StringUtils.isNotEmpty(param.getFsenten())){
			params.add(param.getFsenten());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getAsunto())){
			params.add(param.getAsunto());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(param.getDecision())){
			params.add(param.getDecision());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(param.getFactu());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getNregistro())){
			params.add(param.getNregistro());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(param.getFregistro())){
			params.add(param.getFregistro());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}	
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaTipoSustitucion(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String, java.lang.String)
	 */
	public String anyadirIncidenciaTipoSustitucion(W83bNuevaIncidenciasBean param,String dniSustituido, String dniSustituto)throws Exception {
		int id = Integer.parseInt(maxIdSustitucion())+1;
		
		return anyadirIncidenciaTipoSustitucionId(param,dniSustituido,dniSustituto,String.valueOf(id));
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaTipoSustitucion(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String, java.lang.String)
	 */
	/**
	 * Anyadir incidencia tipo sustitucion id.
	 *
	 * @param param the param
	 * @param dniSustituido the dni sustituido
	 * @param dniSustituto the dni sustituto
	 * @param id the id
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidenciaTipoSustitucionId(W83bNuevaIncidenciasBean param,String dniSustituido, String dniSustituto, String id)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.incidenciasTipoSustitucionSinonimo);
		strSql.append("(");
		strSql.append(W83bIncidenciasTipoSustitucionBD.ID_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.N_INCID_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.ANO_INCID_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.C_TERRIT_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?)");
		
		params.add(new Integer(id));
		params.add(new Integer(param.getIncidenciaNumero()));
		params.add(new Integer(param.getIncidenciaAnyo()));
		params.add(param.getIncidenciaTerritorio());
		if(StringUtils.isNotEmpty(dniSustituido)){
			params.add(dniSustituido.toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(dniSustituto)){
			params.add(dniSustituto.toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaTipoSustitucion(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String, java.lang.String)
	 */
	public String anyadirIncidenciaHistorialTramitacion(W83bIncidenciaHistorialActaBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaRegSal);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_numRegSal);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaNotif);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaExpir);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(", ");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,?),?,");
		if(StringUtils.isNotEmpty(param.getFechaRegSal())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",?,");
		if(StringUtils.isNotEmpty(param.getFechaNotif())){
			strSql.append("to_date(?,?),");
		}else{
			strSql.append("?,");			
		}
		if(StringUtils.isNotEmpty(param.getFechaExpir())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		if(StringUtils.isNotEmpty(param.getFechaModificacionActa())){
			strSql.append(",to_date(?,?)");
		}else{
			strSql.append(",?");			
		}
		strSql.append(",?");
		if (Integer.parseInt(W83bClsConstantes.FASE_CIERRE_MENSUAL)==Integer.parseInt(param.getFaseActa())){
			strSql.append(",to_date(?,?))");
		}
		else{
			strSql.append(",to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'))");
		}
		
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getAnyoActa()));
		params.add(param.getTerritorioActa());
		params.add(new Integer(param.getVersionActa()));
		params.add(new Integer(param.getTramitacionActa()));
		params.add(new Integer(param.getFaseActa()));
		params.add(param.getFechaActualizacionActa());
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		params.add(param.getUsuarioActa());
		if(StringUtils.isNotEmpty(param.getFechaRegSal())){
			params.add(param.getFechaRegSal());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getNumRegSal())){
			params.add(param.getNumRegSal());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(param.getFechaNotif())){
			params.add(param.getFechaNotif());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getFechaExpir())){
			params.add(param.getFechaExpir());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getFechaModificacionActa())){
			params.add(param.getFechaModificacionActa());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(param.getUsuarioModificacionActa())){
			params.add(param.getUsuarioModificacionActa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (Integer.parseInt(W83bClsConstantes.FASE_CIERRE_MENSUAL)==Integer.parseInt(param.getFaseActa())){
			params.add(param.getFechaTram());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		else{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
		}
		//metemos la fecha de tramite en actas como fecha de hoy
		
		
		//TODO INSERTAR IMPUGNACIONES
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	public void editarHistorialTramitacion(W83bActasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ") ;
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(" = ?");
		strSql.append(" WHERE ").append(W83bActasBD.hisTram_territActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_numActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_tram).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_fase).append(" = ? ");
		
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
		
		params.add(param.getNumActaTerritorio());
		params.add(new Integer(param.getNumActaAno()));
		params.add(new Integer(param.getNumActa()));
		params.add(param.getVersion());
		params.add(new Integer(param.getTramite()));
		params.add(new Integer(param.getFase()));
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaAuditoria(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String)
	 */
	public String anyadirIncidenciaHistorial(W83bNuevaIncidenciasBean param,String fechaRegistro)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bIncidenciasHistorialBD.incidenciasHistorialSinonimo);
		strSql.append("(");
		strSql.append(W83bIncidenciasHistorialBD.ANO_INCID_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.N_INCID_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.C_TERRIT_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.C_TRAM_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.C_FASE_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_ACTU_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.USUA_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_REG_SAL_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.N_REG_SAL_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_NOTIF_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_EXPIR_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_MODIF_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.USU_MOD_072);
		strSql.append(", ");
		strSql.append(W83bIncidenciasHistorialBD.F_TRAM_072);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,SYSDATE,?,?,?,?,?,?,?,to_date(?,?))");
		
		params.add(new Integer(param.getIncidenciaAnyo()));
		params.add(new Integer(param.getIncidenciaNumero()));
		params.add(param.getIncidenciaTerritorio());
		params.add(new Integer(param.getTramite()));
		params.add(new Integer(param.getFase()));
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(W83bClsConstantes.NULL_DATE);	
		params.add(W83bClsConstantes.NULL_STRING);	
		params.add(W83bClsConstantes.NULL_DATE);	
		params.add(W83bClsConstantes.NULL_DATE);	
		params.add(W83bClsConstantes.NULL_DATE);	
		params.add(W83bClsConstantes.NULL_STRING);	
//		params.add(param.getUsuarioBean().getIdUsuario());
		
		W83bClsTrazas.trazaDebug(null, "FECHAAAA: "+ fechaRegistro);
		
		if(StringUtils.isNotEmpty(fechaRegistro)){
			params.add(fechaRegistro);
			params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		}
		else{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
			params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		}
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaAuditoria(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String)
	 */
	public String actualizarIncidenciaHistorial(W83bNuevaIncidenciasBean param,String fechaRegistro)throws Exception {
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("UPDATE ") ;
			strSql.append(W83bIncidenciasHistorialBD.incidenciasHistorialSinonimo);
			strSql.append(" SET ");
			strSql.append(W83bIncidenciasHistorialBD.F_MODIF_072);
			strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
			strSql.append(",");
			strSql.append(W83bIncidenciasHistorialBD.USU_MOD_072);
			strSql.append(" = ?");
			strSql.append(" WHERE ").append(W83bIncidenciasHistorialBD.C_TERRIT_072).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasHistorialBD.ANO_INCID_072).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasHistorialBD.N_INCID_072).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_TRAM_072).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_FASE_072).append(" = ? ");
			
			SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
			params.add(sdf.format(new Date()));
			params.add(param.getUsuarioBean().getIdUsuario());
			
			params.add(param.getIncidenciaTerritorio());
			params.add(new Integer(param.getIncidenciaAnyo()));
			params.add(new Integer(param.getIncidenciaNumero()));
			params.add(new Integer(param.getTramite()));
			params.add(new Integer(param.getFase()));
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			
		return "0";
	}
	
	
	public boolean buscarHistorialTramitacion(W83bNuevaIncidenciasBean bean) throws Exception {
		// TODO Auto-generated method stub
						
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ").append(W83bIncidenciasHistorialBD.N_INCID_072).append(" FROM ");
		strSql.append(W83bIncidenciasHistorialBD.incidenciasHistorialSinonimo);
		strSql.append(" WHERE ").append(W83bIncidenciasHistorialBD.C_TERRIT_072).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.ANO_INCID_072).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.N_INCID_072).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_TRAM_072).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.C_FASE_072).append(" = ? ");
		params.add(bean.getIncidenciaTerritorio());
		params.add(new Integer(bean.getIncidenciaAnyo()));
		params.add(new Integer(bean.getIncidenciaNumero()));
		params.add(new Integer(bean.getTramite()));
		params.add(new Integer(bean.getFase()));
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,bean.getUsuarioBean());
		
		if(listaActas.size()>0){
			return true;
		}
		
		return false;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#anyadirIncidenciaAuditoria(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String)
	 */
	public String anyadirIncidenciaAuditoria(W83bNuevaIncidenciasBean param,String modo)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bIncidenciasAuditoriaBD.incidenciasAuditoriaSinonimo);
		strSql.append("(");
		strSql.append(W83bIncidenciasAuditoriaBD.N_INCID_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.ANO_INCID_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.C_TERRIT_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.FACTU_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.USUA_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.DESC_CAS_074);
		strSql.append(", ");
		strSql.append(W83bIncidenciasAuditoriaBD.DESC_EUS_074);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,SYSDATE,?,?,?)");
		
		params.add(new Integer(param.getIncidenciaNumero()));
		params.add(new Integer(param.getIncidenciaAnyo()));
		params.add(param.getIncidenciaTerritorio());
		params.add(param.getUsuarioBean().getIdUsuario());
		if(W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_LECTURA.equals(modo)){
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesoincidencia", W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesoincidencia", W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase());
		}else if(W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ESCRITURA.equals(modo)){
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertincidencia", W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertincidencia", W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase());			
		}else if(W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_ACTUALIZACION.equals(modo)){
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editincidencia", W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editincidencia", W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase());			
		}else if(W83bClsConstantes.CONSTANTE_HISTORIAL_MODO_BORRADO.equals(modo)){
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.deleteincidencia", W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
			params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.deleteincidencia", W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase());		
		}
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarDiferencia(w83b.w83bBeans.W83bListaDiferenciasBean)
	 */
	public String insertarDiferencia(W83bListaDiferenciasBean diferencia) throws Exception{
		//FUNCIN COPIADA CON ALGUNOS CAMBIOS DE ACTASDAO
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bDiferenciasBD.difTable);
		strSql.append("(").append(W83bDiferenciasBD.acta).append(",");
		strSql.append(W83bDiferenciasBD.anyoActa).append(",");
		strSql.append(W83bDiferenciasBD.territorioActa).append(",");
		strSql.append(W83bDiferenciasBD.versionActa).append(",");
		strSql.append(W83bDiferenciasBD.codSind).append(",");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(",");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(",");
		strSql.append(W83bDiferenciasBD.usuario).append(",");
		strSql.append(W83bDiferenciasBD.fecha).append(") VALUES (?,?,?,?,?,?,?,?,?,");
		strSql.append("to_date(?,?))");			
	


		params.add(diferencia.getActa());
		params.add(diferencia.getAnyoActa());
		params.add(diferencia.getTerritorioActa());
		params.add(diferencia.getVersionActa());
		params.add(diferencia.getSindicato());
		params.add(diferencia.getCodColegio());
		params.add(diferencia.getHombres());
		params.add(diferencia.getMujeres());
		if(StringUtils.isNotEmpty(diferencia.getUsuario())){
			params.add(diferencia.getUsuario());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		params.add(diferencia.getFecha());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(diferencia.getIdioma()));

		W83bDataBase.executeTableMovement(strSql.toString(), params,diferencia.getUsuarioBean());
		
		return "0";	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarEscrutinio(w83b.w83bBeans.W83bEscrutinioBean)
	 */
	public String insertarEscrutinio(W83bEscrutinioBean escrutinio) throws Exception{
		//FUNCIN COPIADA CON ALGUNOS CAMBIOS DE ACTASDAO
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bEscrutiniosBD.escrutTable);
		strSql.append("(").append(W83bEscrutiniosBD.acta).append(",");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(",");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(",");
		strSql.append(W83bEscrutiniosBD.versionActa).append(",");
		strSql.append(W83bEscrutiniosBD.codSind).append(",");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(",");
		strSql.append(W83bEscrutiniosBD.numVotos).append(",");
		strSql.append(W83bEscrutiniosBD.usuario).append(",");
		strSql.append(W83bEscrutiniosBD.fecha).append(") VALUES (?,?,?,?,?,?,?,?,?,?,");
		if(StringUtils.isNotEmpty(escrutinio.getFecha())){
			strSql.append("to_date(?,?))");
		}else{
			strSql.append("?)");			
		}
		
		params.add(escrutinio.getActaNumero());
		params.add(escrutinio.getActaAnyo());
		params.add(escrutinio.getActaTerritorio());
		params.add(escrutinio.getActaVersion());
		params.add(escrutinio.getCodSindicato());
		params.add(escrutinio.getCodColegio());
		params.add(escrutinio.getDelegadosHombres());
		params.add(escrutinio.getDelegadosMujeres());
		params.add(escrutinio.getNumVotos());
		if(StringUtils.isNotEmpty(escrutinio.getUsuario())){
			params.add(escrutinio.getUsuario());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(escrutinio.getFecha())){
			params.add(escrutinio.getFecha());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(escrutinio.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
	
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,escrutinio.getUsuarioBean());
		
		return "0";	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarDelegado(w83b.w83bBeans.W83bDelegadosBean)
	 */
	public String insertarDelegado(W83bDelegadosBean delegado,boolean fActuSysDate) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(delegado.getUsuarioBean().getIdUsuario());
		
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bDelegadosBD.delegadosVista);
		strSql.append("(").append(W83bDelegadosBD.acta).append(",").append(W83bDelegadosBD.anyoActa).append(",");
		strSql.append(W83bDelegadosBD.territorioActa).append(",");
		strSql.append(W83bDelegadosBD.versionActa).append(",");
		strSql.append(W83bDelegadosBD.codSindicato).append(",").append(W83bDelegadosBD.codColegio).append(",");
		strSql.append(W83bDelegadosBD.dni).append(",");
		strSql.append(W83bDelegadosBD.nombre).append(",").append(W83bDelegadosBD.apellido1).append(",");
		strSql.append(W83bDelegadosBD.apellido2).append(",");
		strSql.append(W83bDelegadosBD.sexo).append(",");
		strSql.append(W83bDelegadosBD.dniSustituto).append(",");
		strSql.append(W83bDelegadosBD.usuario).append(",");
		strSql.append(W83bDelegadosBD.baja).append(",").append(W83bDelegadosBD.fechaBaja).append(",");
		strSql.append(W83bDelegadosBD.fechaMod).append(",");
		strSql.append(W83bDelegadosBD.fechaAlta).append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
		if(StringUtils.isNotEmpty(delegado.getFechaBaja())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}	
		if(fActuSysDate){
			strSql.append(" ,SYSDATE");
		}else{
			strSql.append(" ,to_date(?,?)");			
		}
		strSql.append(" ,to_date(?,?))");

		params.add(delegado.getActaNum());
		params.add(delegado.getActaAnyo());
		params.add(delegado.getActaTerritorio());
		params.add(delegado.getActaVersion());
		if(StringUtils.isNotEmpty(delegado.getCodSindicato())){
			params.add(new Integer(delegado.getCodSindicato()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(delegado.getCodColegio())){
			params.add(new Integer(delegado.getCodColegio()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(delegado.getDniDelegado().toUpperCase());
		params.add(delegado.getNombreDelegado().toUpperCase());
		params.add(delegado.getPrimerApellidoDelegado().toUpperCase());
		params.add(delegado.getSegundoApellidoDelegado().toUpperCase());
		params.add(delegado.getSexoDelegado().toUpperCase());
		
		if(StringUtils.isNotEmpty(delegado.getDniSustituto())){
			params.add(delegado.getDniSustituto().toUpperCase());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(delegado.getUsuarioBean().getIdUsuario());

		if(StringUtils.isNotEmpty(delegado.getCodBaja())){
			params.add(delegado.getCodBaja());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(delegado.getFechaBaja())){
			params.add(delegado.getFechaBaja());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(delegado.getIdioma()));
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(!fActuSysDate){
			if(StringUtils.isNotEmpty(delegado.getFActu())){
				params.add(delegado.getFActu());
				params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(delegado.getIdioma()));
			}
			else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
		}
		if(StringUtils.isNotEmpty(delegado.getFechaAlta())){
			params.add(delegado.getFechaAlta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(delegado.getIdioma()));
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,delegado.getUsuarioBean());
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return "0";	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarPapeletas(w83b.w83bBeans.W83bPapeletasBean)
	 */
	public String insertarPapeletas(W83bPapeletasBean papeletas) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bPapeletasBD.papeletasTable);
		strSql.append("(").append(W83bPapeletasBD.acta).append(",");
		strSql.append(W83bPapeletasBD.anyoActa).append(",");
		strSql.append(W83bPapeletasBD.territorioActa).append(",");
		strSql.append(W83bPapeletasBD.versionActa).append(",");
		strSql.append(W83bPapeletasBD.codColegio).append(",");
		strSql.append(W83bPapeletasBD.validas).append(",");
		strSql.append(W83bPapeletasBD.nulas).append(",");
		strSql.append(W83bPapeletasBD.blancas).append(",");
		strSql.append(W83bPapeletasBD.votantes).append(",");
		strSql.append(W83bPapeletasBD.electores).append(") VALUES (?,?,?,?,?,?,?,?,?,?)");

		params.add(papeletas.getNumActa());
		params.add(papeletas.getAnyoActa());
		params.add(papeletas.getTerritorioActa());
		params.add(papeletas.getVersionActa());
		params.add(papeletas.getColegio());
		
		if(StringUtils.isNotEmpty(papeletas.getValidas())){
			params.add(papeletas.getValidas());			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		if(StringUtils.isNotEmpty(papeletas.getNulas())){
			params.add(papeletas.getNulas());			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		if(StringUtils.isNotEmpty(papeletas.getBlancas())){
			params.add(papeletas.getBlancas());			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		if(StringUtils.isNotEmpty(papeletas.getVotantes())){
			params.add(papeletas.getVotantes());			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		if(StringUtils.isNotEmpty(papeletas.getElectores())){
			params.add(papeletas.getElectores());			
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,papeletas.getUsuarioBean());
		
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarDocsActas(w83b.w83bBeans.W83bDocBeanIncidencia)
	 */
	public String insertarDocsActas(w83b.w83bBeans.W83bDocBeanIncidencia param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		

			strSql.append("INSERT INTO ");
			strSql.append(W83bActasBD.actas_docsTable).append("(");
			strSql.append(W83bActasBD.doc_id).append(",");
			strSql.append(W83bActasBD.doc_nombre).append(",");
			strSql.append(W83bActasBD.doc_longitud).append(",");
			strSql.append(W83bActasBD.doc_documento).append(",");
			strSql.append(W83bActasBD.doc_territActa).append(",");
			strSql.append(W83bActasBD.doc_tram).append(",");
			strSql.append(W83bActasBD.doc_fase).append(",");
			strSql.append(W83bActasBD.doc_anyoActa).append(",");
			strSql.append(W83bActasBD.doc_numActa).append(",");
			strSql.append(W83bActasBD.doc_versionActa).append(",");
			strSql.append(W83bActasBD.doc_tipo).append(",");
			strSql.append(W83bActasBD.doc_numReg).append(",");
			strSql.append(W83bActasBD.doc_fechaReg).append(",");
			strSql.append(W83bActasBD.doc_usuario).append(",");
			strSql.append(W83bActasBD.doc_fechaActualizacion).append(")");			

			strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,");
			
			if(StringUtils.isNotEmpty(param.getFechaRegistro())){
				strSql.append("to_Date(?,?)");
			}else{
				strSql.append("?");				
			}
			
			strSql.append(",?,");
			
			if(StringUtils.isNotEmpty(param.getFecActu())){
				strSql.append("to_date(?,?))");
			}else{
				strSql.append("?)");				
			}
			
			
			params.add(param.getId());
			if(StringUtils.isNotEmpty(param.getNombre())){
				params.add(param.getNombre());
				params.add(param.getLongitudDocumento());
				params.add(param.getFileDataBlob());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
				params.add(W83bClsConstantes.NULL_INTEGER);
				params.add(W83bClsConstantes.NULL_BLOB);
			}
			params.add(param.getNumActaTerritorio());
			params.add(param.getCodTramite());
			params.add(param.getCodFase());
			params.add(param.getNumActaAno());
			params.add(param.getNumActa());
			params.add(param.getVersionActa());
			if(StringUtils.isNotEmpty(param.getTipoDocumento())){
				params.add(param.getTipoDocumento());
			}else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(param.getNumeroRegistro())){
				params.add(param.getNumeroRegistro());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if(StringUtils.isNotEmpty(param.getFechaRegistro())){
				params.add(param.getFechaRegistro());
				if(param.getFechaRegistro().length()>10){
					params.add(W83bDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma(param.getIdioma()));					
				}else{
					params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));					
				}
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			params.add(param.getUsuario());
			if(StringUtils.isNotEmpty(param.getFecActu())){
				params.add(param.getFecActu());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			
			W83bDataBase.executeBlobTableMovement(strSql.toString(), params,Integer.parseInt(param.getLongitudDocumento()),param.getUsuarioBean());
				
			params.clear();
				
			return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#actualizarDelegadosSustituidosIncidencias(w83b.w83bBeans.W83bDelegadosBean, java.lang.String)
	 */
	public String actualizarDelegadosSustituidosIncidencias(W83bDelegadosBean delegado,String versionActa) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(delegado.getUsuarioBean().getIdUsuario());
		
		strSql.append("UPDATE ") ;
		strSql.append(W83bDelegadosBD.delegadosVista);
		strSql.append(" SET ");
		strSql.append(W83bDelegadosBD.fechaBaja);
		strSql.append(" = SYSDATE");
		strSql.append(",");
		strSql.append(W83bDelegadosBD.dniSustituto);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bDelegadosBD.baja);
		strSql.append(" = ?");

		strSql.append(" WHERE ").append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.dni).append(" = ? ");
		
		if(StringUtils.isNotEmpty(delegado.getDniSustituto())){
			params.add(delegado.getDniSustituto().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		params.add(delegado.getCodBaja());
		
		params.add(delegado.getActaTerritorio());
		params.add(delegado.getActaAnyo());
		params.add(delegado.getActaNum());
		params.add(versionActa);
		params.add(delegado.getDniSustituido());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,delegado.getUsuarioBean());
		
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarActa(w83b.w83bBeans.W83bActasIncidenciaBean)
	 */
	public String insertarActa(W83bActasIncidenciaBean acta) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bActasBD.actasTable);
		strSql.append("(").append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(",");
		strSql.append(W83bActasBD.numPreaviso).append(",");
		strSql.append(W83bActasBD.anyoPreaviso).append(",");
		strSql.append(W83bActasBD.codConvenio).append(",");
		strSql.append(W83bActasBD.codCentro).append(",");
		strSql.append(W83bActasBD.codMotivosBaja).append(",");
		strSql.append(W83bActasBD.fechaEntrada).append(",");//10
		strSql.append(W83bActasBD.fechaEleccion).append(",");
		strSql.append(W83bActasBD.totaldel).append(",");
		strSql.append(W83bActasBD.totalElectores).append(",");
		strSql.append(W83bActasBD.nCandidatosHombre).append(",");
		strSql.append(W83bActasBD.nCandidatosMujer).append(",");
		strSql.append(W83bActasBD.anyoTotalActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegistro).append(",");
		strSql.append(W83bActasBD.fechaRegistro).append(",");
		strSql.append(W83bActasBD.anyoRegDefinitivo).append(",");//20
		strSql.append(W83bActasBD.numRegDefinitivo).append(",");
		strSql.append(W83bActasBD.fecRegDefinitivo).append(",");
		strSql.append(W83bActasBD.fechaComision).append(",");
		strSql.append(W83bActasBD.fechaRequerimiento).append(",");
		strSql.append(W83bActasBD.fechaSubsanacionReq).append(",");
		strSql.append(W83bActasBD.fechaRetiradaComision).append(",");
		strSql.append(W83bActasBD.fechaPresentacionRegRegInterno).append(",");
		strSql.append(W83bActasBD.fechaBaja).append(",");
		strSql.append(W83bActasBD.delHombres).append(",");
		strSql.append(W83bActasBD.delMujeres).append(",");//30
		strSql.append(W83bActasBD.nElectoresHombre).append(",");
		strSql.append(W83bActasBD.nElectoresMujer).append(",");
		strSql.append(W83bActasBD.marcaComision).append(",");
		strSql.append(W83bActasBD.observaciones).append(",");
		strSql.append(W83bActasBD.usuarioActualizacion).append(",");
		strSql.append(W83bActasBD.fechaActualizacion).append(",");
		strSql.append(W83bActasBD.inspeccionada).append(",");
		strSql.append(W83bActasBD.F_CONSTCOM_016).append(",");
		strSql.append(W83bActasBD.maxDel).append(",");
		strSql.append(W83bActasBD.validada).append(",");
		strSql.append(W83bActasBD.nueva);		
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,to_Date(?,?),to_Date(?,?),?,?,?,?,?,?,?,");
		if(StringUtils.isNotEmpty(acta.getFechaRegistro())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",?,?,");
		if(StringUtils.isNotEmpty(acta.getFecRegDefinitivo())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaComision())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaRequerimiento())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaSubsanacionReq())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaRetiradaComision())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaPresentacionRegRegInterno())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",");
		if(StringUtils.isNotEmpty(acta.getFechaBaja())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}

		strSql.append(",?,?,?,?,?,?,?,");
		if(StringUtils.isNotEmpty(acta.getFechaActualizacion())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",?,");
		if(StringUtils.isNotEmpty(acta.getF_CONSTCOM_016())){
			strSql.append("to_Date(?,?)");
		}else{
			strSql.append("?");			
		}
		strSql.append(",?,?,?)");

		params.add(acta.getNumActa());
		params.add(acta.getAnyoActa());
		params.add(acta.getVersionActa());
		params.add(acta.getCodTerritActa());
		if(StringUtils.isNotEmpty(acta.getNumPreaviso())){
			params.add(acta.getNumPreaviso());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		if(StringUtils.isNotEmpty(acta.getAnyoPreaviso())){
			params.add(acta.getAnyoPreaviso());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		if(StringUtils.isNotEmpty(acta.getCodConvenio())){
			params.add(acta.getCodConvenio());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(acta.getCodCentro());
		if(StringUtils.isNotEmpty(acta.getCodMotivosBaja())){
			params.add(acta.getCodMotivosBaja());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(acta.getFechaEntrada());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		params.add(acta.getFechaEleccion());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		if(StringUtils.isNotEmpty(acta.getTotalTrabajadores())){
			params.add(acta.getTotalTrabajadores());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(acta.getTotalElectores());
		params.add(acta.getNCandidatosHombre());
		params.add(acta.getNCandidatosMujer());
		if(StringUtils.isNotEmpty(acta.getAnyoTotalActa())){
			params.add(acta.getAnyoTotalActa());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNumTotalActa())){
			params.add(acta.getNumTotalActa());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNumRegistro())){//20
			params.add(acta.getNumRegistro());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getFechaRegistro())){
			params.add(acta.getFechaRegistro());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getAnyoRegDefinitivo())){
			params.add(acta.getAnyoRegDefinitivo());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNumRegDefinitivo())){
			params.add(acta.getNumRegDefinitivo());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getFecRegDefinitivo())){
			params.add(acta.getFecRegDefinitivo());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaComision())){
			params.add(acta.getFechaComision());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaRequerimiento())){
			params.add(acta.getFechaRequerimiento());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaSubsanacionReq())){
			params.add(acta.getFechaSubsanacionReq());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaRetiradaComision())){
			params.add(acta.getFechaRetiradaComision());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaPresentacionRegRegInterno())){
			params.add(acta.getFechaPresentacionRegRegInterno());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getFechaBaja())){
			params.add(acta.getFechaBaja());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getNTrabHombre())){
			params.add(acta.getNTrabHombre());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNTrabMujer())){
			params.add(acta.getNTrabMujer());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNElectoresHombre())){
			params.add(acta.getNElectoresHombre());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getNElectoresMujer())){
			params.add(acta.getNElectoresMujer());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getMarcaComision())){
			params.add(acta.getMarcaComision());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(acta.getObservaciones())){
			params.add(acta.getObservaciones());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(acta.getUsuarioActualizacion())){
			params.add(acta.getUsuarioActualizacion());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(acta.getFechaActualizacion())){
			params.add(acta.getFechaActualizacion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getInspeccionada())){
			params.add(acta.getInspeccionada());
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getF_CONSTCOM_016())){
			params.add(acta.getF_CONSTCOM_016());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if(StringUtils.isNotEmpty(acta.getMaxDel())){
			params.add(new Integer(acta.getMaxDel()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getValidada())){
			params.add(acta.getValidada());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(acta.getNueva())){
			params.add(acta.getNueva());
		}else{
			params.add("0");
		}
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		
		return "0";
	}
	
	
	/**
	 * Insertar docs incidencias.
	 *
	 * @param param the param
	 * @throws Exception the exception
	 */
	public String insertarDocsIncidencias(W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();
		StringBuffer strSql2 = new StringBuffer();
		List params = new ArrayList();
		
		String resultado = "";
		
		
		//voy a insertar los documentos adjuntos
		if (param.getListaDocs().size()>0)
		{
			StringBuffer strSqlCorrelativo = new StringBuffer();
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83bIncidenciasDocsBD.ID_DOC_064);
			strSqlCorrelativo.append(") FROM ");
			strSqlCorrelativo.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
			
			List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
			int idDocNext=1;
			
			if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
			{
				idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
			}
			strSql = new StringBuffer();
			params = new ArrayList();

			strSql.append("INSERT INTO ");
			strSql.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
			
			strSql.append("(");
			strSql.append(W83bIncidenciasDocsBD.ID_DOC_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.NOMB_DOCU_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.LONG_DOCU_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.FICHERO_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.C_TERRIT_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.C_TRAM_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.C_FASE_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.ANO_INCID_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.N_INCID_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.TP_DOC_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.NUM_REG_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.F_REG_064);
			strSql.append(",");
			strSql.append(W83bIncidenciasDocsBD.USUARIO_064);
			strSql.append(")");
			

			strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,");
			strSql2.append(strSql);
			if ("1".equals(param.getUsuarioBean().getRegManual())){
				strSql.append("to_date(?,?)");				
			}else{
				strSql.append("?");				
			}
			strSql2.append("?");				
			
			strSql.append(",?)");
			strSql2.append(",?)");
			
			
			StringBuffer strSqlLibro = new StringBuffer();
			ArrayList paramsLibro = new ArrayList();
			 
			strSqlLibro.append("UPDATE ") ;
			strSqlLibro.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
			strSqlLibro.append(" SET ");
			strSqlLibro.append(W83bIncidenciasDocsBD.F_REG_064);
			strSqlLibro.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
			strSqlLibro.append(",");
			strSqlLibro.append(W83bIncidenciasDocsBD.NUM_REG_064);
			strSqlLibro.append(" = ?");
			strSqlLibro.append(" WHERE ").append(W83bIncidenciasDocsBD.C_TERRIT_064).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bIncidenciasDocsBD.ANO_INCID_064).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bIncidenciasDocsBD.N_INCID_064).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bIncidenciasDocsBD.ID_DOC_064).append(" = ? ");
			
			StringBuffer strSqlFinal = new StringBuffer();
			
			if(StringUtils.isEmpty(param.getActaOriginal().getCodCentroTrabajo())){
				HashMap datosActa = obtenerActasCodCentro(param.getIncidenciaTerritorio(),param.getActaAnyo(),param.getActaNumero(),param.getActaVersion(),param.getIdioma());
				param.getActaOriginal().setCodCentroTrabajo(datosActa.get(W83bActasBD.codCentro).toString());
			}
			
			
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				strSqlFinal =  new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
				strSqlFinal.append(strSql);
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				//esto no va a ser asi cuando pongan la secuencia
				params.add(new Integer(idDocNext));//NOPMD
				params.add(doc.getNombre().toUpperCase());
				params.add(new Integer(doc.getTamanyo()));//NOPMD
				params.add(doc.getFileData());
				params.add(param.getIncidenciaTerritorio().toUpperCase());
				if (StringUtils.isNotEmpty(doc.getCodTramite()))
				{
					params.add(doc.getCodTramite().toUpperCase());
					
				}
				else
				{
					params.add("1");
				}
				if (StringUtils.isNotEmpty(doc.getCodFase()))
				{
					params.add(doc.getCodFase().toUpperCase());
					
				}
				else
				{
					params.add("1");
				}
				params.add(param.getIncidenciaAnyo().toUpperCase());
				params.add(param.getIncidenciaNumero());
				params.add (doc.getTipoDocumento().toUpperCase());
				if ("1".equals(param.getUsuarioBean().getRegManual()))
				{
					if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
						params.add(doc.getNumeroRegistro());							
					}else{
						params.add(W83bClsConstantes.NULL_STRING);						
					}
					if(StringUtils.isNotEmpty(doc.getFechaRegistro())){
						params.add(doc.getFechaRegistro());							
						params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
					}else{
						strSqlFinal =  new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
						strSqlFinal.append(strSql2);
						params.add(W83bClsConstantes.NULL_DATE);						
					}					
				}
				else
				{
					params.add(W83bClsConstantes.NULL_STRING);
					params.add(W83bClsConstantes.NULL_DATE);
				}				
				params.add(doc.getUsuario().toUpperCase());
				
				W83bDataBase.executeBlobTableMovement(strSqlFinal.toString(), params,doc.getTamanyo(),param.getUsuarioBean());
				
				params.clear();
				if ("0".equals(param.getUsuarioBean().getRegManual()))
				{
					//libro de registro

					//Libro Registro
					 String observaciones="Incidencia n: "+param.getIncidenciaTerritorio()+"/"+param.getIncidenciaAnyo()+"/"+param.getIncidenciaNumero();//NOPMD
					 String empresa="";
					 empresa=param.getDniSolicitante();
					 
					 if(StringUtils.isEmpty(empresa)){
						 empresa = param.getActaOriginal().getCodCentroTrabajo();
					 }
					 
					 W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion(param.getUsuarioBean());
					 
					 param.getUsuarioBean().setModelo(usuarioLimitado.getModelo());
					 param.getUsuarioBean().setModeloSal(usuarioLimitado.getModeloSal());
					try{  
						
						String [] resul=W83bLibroRegistro.getAltaRegistro(true, param.getUsuarioBean().getModelo(), "E", "E", empresa, param.getIncidenciaTerritorio(), "", observaciones, param.getUsuarioBean());
						//Fin Libro Registro
						doc.setFechaRegistro(resul[1]);
						doc.setNumeroRegistro(resul[0]);
						paramsLibro.add(resul[1]);
						paramsLibro.add(resul[0]);
						paramsLibro.add(param.getIncidenciaTerritorio());
						paramsLibro.add(new Integer(param.getIncidenciaAnyo()));//NOPMD
						paramsLibro.add(new Integer(param.getIncidenciaNumero()));//NOPMD
						paramsLibro.add(new Integer(idDocNext));//NOPMD
						
						W83bDataBase.executeTableMovement(strSqlLibro.toString(), paramsLibro,param.getUsuarioBean());
					}catch(W83bLibroRegistroException e){
						resultado = "true";
					}
				}
				paramsLibro.clear();

				idDocNext++;
			}
		}
		
		return resultado;
	}
	
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	/**
	 * Max id subsanaciones.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxIdSubsanaciones()throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bSubsanacionesBD.ID_066);
		
		strSql.append(") FROM ").append(W83bSubsanacionesBD.table);
		
		List listaSubsanaciones = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "-1";
		
		if(null!=listaSubsanaciones.get(0)){
			respuesta = listaSubsanaciones.get(0).toString();
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#maxVersionIncidencia(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String maxIdSustitucion()throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bIncidenciasTipoSustitucionBD.ID_067);
		
		strSql.append(") FROM ").append(W83bIncidenciasTipoSustitucionBD.incidenciasTipoSustitucionSinonimo);
		
		List listaSustitucion = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String respuesta = "-1";
		
		if(null!=listaSustitucion.get(0)){
			respuesta = listaSustitucion.get(0).toString();
		}
		
		return respuesta; 		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarCamposModifSubsanaciones(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String insertarCamposModifSubsanaciones(W83bNuevaIncidenciasBean incidencia,String campo,String valorAnterior, String valorActual) throws Exception{
		int id = Integer.parseInt(maxIdSubsanaciones())+1;
		
		insertarCamposModifSubsanacionesId(incidencia,String.valueOf(id),campo,valorAnterior, valorActual);
		
		return "";
	}
	
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#insertarCamposModifSubsanaciones(w83b.w83bBeans.W83bNuevaIncidenciasBean, java.lang.String, java.lang.String, java.lang.String)
	 */
	/**
	 * Insertar campos modif subsanaciones id.
	 *
	 * @param incidencia the incidencia
	 * @param id the id
	 * @param campo the campo
	 * @param valorAnterior the valor anterior
	 * @param valorActual the valor actual
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarCamposModifSubsanacionesId(W83bNuevaIncidenciasBean incidencia,String id,String campo,String valorAnterior, String valorActual) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
			

			strSql.append("INSERT INTO ");
			strSql.append(W83bSubsanacionesBD.table);
			strSql.append("(");
			strSql.append(W83bSubsanacionesBD.ID_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.C_TERRIT_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.ANO_INCID_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.N_INCID_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.COD_CAMPO_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.VALOR_ANT_066);
			strSql.append(",");
			strSql.append(W83bSubsanacionesBD.VALOR_ACTUAL_066);
			strSql.append(")");
			
			strSql.append(" VALUES (?,?,?,?,?,?,?)");
			
			
			params.add(id);
			params.add(incidencia.getIncidenciaTerritorio());
			params.add(incidencia.getIncidenciaAnyo());
			params.add(incidencia.getIncidenciaNumero());
			params.add(campo);
			if(StringUtils.isNotEmpty(valorAnterior)){
				params.add(valorAnterior);
			}else{
				params.add(W83bClsConstantes.NULL_STRING);				
			}
			if(StringUtils.isNotEmpty(valorActual)){
				params.add(valorActual);
			}else{
				params.add(W83bClsConstantes.NULL_STRING);				
			}
			
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,incidencia.getUsuarioBean());
				
			params.clear();
				
			return "0";
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List detalleIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();
		
			strSql.append("SELECT ");
			strSql.append("DISTINCT(");
			strSql.append(W83bIncidenciasVistaBD.numacta).append("), ");
			strSql.append("TO_CHAR(");
			strSql.append(W83bIncidenciasVistaBD.fentrada).append(",?) AS ").append(W83bIncidenciasVistaBD.fentrada);
			strSql.append(", ");
			strSql.append("TO_CHAR(");
			strSql.append(W83bIncidenciasVistaBD.fregistro).append(",?) AS ").append(W83bIncidenciasVistaBD.fregistro);
			strSql.append(", ");
			strSql.append("TO_CHAR(");
			strSql.append(W83bIncidenciasVistaBD.fvalidacion).append(",?) AS ").append(W83bIncidenciasVistaBD.fvalidacion);
			strSql.append(", ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(W83bIncidenciasVistaBD.tipsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.nomsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia_es).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipincidencia_eu).append(", ");
			strSql.append(W83bIncidenciasVistaBD.territorioincidencias).append(", ");
			strSql.append(W83bIncidenciasVistaBD.anyoincidencias).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numincidenciasencillocompleto).append(", ");
			strSql.append(W83bIncidenciasVistaBD.fentrada).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numreg).append(", ");
			strSql.append(W83bIncidenciasVistaBD.tipsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.dnisolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.nomsolicitante).append(", ");
			strSql.append(W83bIncidenciasVistaBD.observaciones).append(", ");
			strSql.append(W83bIncidenciasVistaBD.nactacompleto).append(", ");
			strSql.append(W83bIncidenciasVistaBD.anyoacta).append(", ");
			strSql.append(W83bIncidenciasVistaBD.NUMACTAPARSENCILLOCOMPLETO).append(", ");
			strSql.append(W83bIncidenciasVistaBD.ANYOACTASPARCIAL).append(", ");
			strSql.append(W83bIncidenciasVistaBD.versionActa).append(", ");
			strSql.append(W83bIncidenciasVistaBD.numRegDef).append(", ");
			strSql.append(W83bIncidenciasVistaBD.fechaRegDef).append(", ");
			strSql.append("TO_CHAR(");
			strSql.append(W83bIncidenciasVistaBD.fechaBaja).append(",?) AS ").append(W83bIncidenciasVistaBD.fechaBaja);
			strSql.append(", ");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
				strSql.append(W83bIncidenciasVistaBD.tipincidencia_es).append(" as ").append(W83bIncidenciasVistaBD.tipincidencia_es).append(", ");
			}else{
				strSql.append(W83bIncidenciasVistaBD.tipincidencia_eu).append(" as ").append(W83bIncidenciasVistaBD.tipincidencia_es).append(", ");
			}
			if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
				strSql.append(W83bIncidenciasVistaBD.tipsolicitante_es).append(" as ").append(W83bIncidenciasVistaBD.tipsolicitante_es).append(", ");
			}else{
				strSql.append(W83bIncidenciasVistaBD.tipsolicitante_eu).append(" as ").append(W83bIncidenciasVistaBD.tipsolicitante_es).append(", ");
			}
			strSql.append(W83bIncidenciasVistaBD.flagvalidada);
		strSql.append(" FROM ").append(W83bIncidenciasVistaBD.incidenciasView);
		
		strSql.append(" WHERE ");
		
		//NMERO DE INCIDENCIA
			strSql.append(" ").append(W83bIncidenciasVistaBD.territorioincidencias).append(" = ?");
			strSql.append(" and ");
			params.add(param.getIncidenciaTerritorio());
			strSql.append(" ").append(W83bIncidenciasVistaBD.anyoincidencias).append(" = ?");
			strSql.append(" and ");
			params.add(Integer.valueOf(param.getIncidenciaAnyo()));
			strSql.append(" ").append(W83bIncidenciasVistaBD.nincidencias).append(" = ?");
			params.add(Integer.valueOf(param.getIncidenciaNumero()));
		//fin NMERO DE INCIDENCIA
		
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bNuevaIncidenciasBean.class,param.getUsuarioBean(), param.getIdioma());
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List obtenerCambiosSubsanacionIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		List params = new ArrayList();
		
		strSql.append("SELECT t66.");
		strSql.append(W83bSubsanacionesBD.N_INCID_066).append(", t66.");
		strSql.append(W83bSubsanacionesBD.ANO_INCID_066).append(", t66.");
		strSql.append(W83bSubsanacionesBD.VALOR_ANT_066).append(", t66.");
		strSql.append(W83bSubsanacionesBD.VALOR_ACTUAL_066).append(", t66.");
		strSql.append(W83bSubsanacionesBD.C_TERRIT_066).append(", upper(t65.");		    
		
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(" ").append(W83bMigracionBD.nomCampo065).append(") as ").append(W83bMigracionBD.nomCampo065);
		}else{
			strSql.append(" ").append(W83bMigracionBD.nomCampoE065).append(") as ").append(W83bMigracionBD.nomCampo065);
		}
		strSql.append(" FROM ").append(W83bSubsanacionesBD.table);
		strSql.append(" t66, ").append(W83bMigracionBD.tabla65).append(" t65 ");
		
		strSql.append(" WHERE ");
		
		//NMERO DE INCIDENCIA
		strSql.append(" t66.").append(W83bSubsanacionesBD.COD_CAMPO_066).append(" = ");
		strSql.append(" t65.").append(W83bMigracionBD.codCampo065);
		strSql.append(" and ");
		strSql.append(" t66.").append(W83bSubsanacionesBD.C_TERRIT_066).append(" = ?");
		params.add(param.getIncidenciaTerritorio());
		strSql.append(" and ");
		strSql.append(" t66.").append(W83bSubsanacionesBD.ANO_INCID_066).append(" = ?");
		strSql.append(" and ");
		params.add(Integer.valueOf(param.getIncidenciaAnyo()));
		strSql.append(" t66.").append(W83bSubsanacionesBD.N_INCID_066).append(" = ?");
		params.add(Integer.valueOf(param.getIncidenciaNumero()));
		//fin NMERO DE INCIDENCIA
		
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciasSubsanacionCambioBean.class,param.getUsuarioBean(), param.getIdioma());
	}
	
	
	/**
	 * Existe acta tabla actas.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public List obtenerDelegadosSustitucion(W83bNuevaIncidenciasBean incidencia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.DNI_SUSTITUTO_067);
		strSql.append(", ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.DNI_SUTITUIDO_067);
		
		strSql.append(" FROM ").append(W83bIncidenciasTipoSustitucionBD.incidenciasTipoSustitucionSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasTipoSustitucionBD.ANO_INCID_067).append(" = ? ");
		params.add(new Integer(incidencia.getIncidenciaAnyo()));		
		strSql.append(" AND ").append(W83bIncidenciasTipoSustitucionBD.N_INCID_067).append(" = ? ");
		params.add(new Integer(incidencia.getIncidenciaNumero()));		
		strSql.append(" AND ").append(W83bIncidenciasTipoSustitucionBD.C_TERRIT_067).append(" = ? ");
		params.add(incidencia.getIncidenciaTerritorio());		
		
		
		return W83bDataBase.executeQuery(strSql.toString(),params,incidencia.getUsuarioBean());		
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List buscarDetalleDelegadoIncidencias(w83b.w83bBeans.W83bDelegadosBean param,boolean bajaVersionAnterior) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.acta).append(", ");
		strSql.append(W83bDelegadosBD.anyoActa).append(", ");
		strSql.append(W83bDelegadosBD.apellido1).append(", ");
		strSql.append(W83bDelegadosBD.apellido2).append(", ");
		strSql.append(W83bDelegadosBD.baja).append(", ");
		strSql.append(W83bDelegadosBD.codColegio).append(", ");
		
		strSql.append(W83bDelegadosBD.codSindicato).append(", ");
		
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" as ").append(W83bSindicatosBD.descSindicatoCast).append(", ");
		}else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" as ").append(W83bSindicatosBD.descSindicatoCast).append(", ");			
		}
		strSql.append(W83bSindicatosBD.siglas).append(" as ").append(W83bSindicatosBD.siglas).append(", ");			
		strSql.append(W83bDelegadosBD.dni).append(", ");
		strSql.append(W83bDelegadosBD.dniSustituto).append(", to_char(");
		strSql.append(W83bDelegadosBD.fechaAlta).append(",?) as ").append(W83bDelegadosBD.fechaAlta);
		strSql.append(",to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bDelegadosBD.fechaBaja).append(",?) as ").append(W83bDelegadosBD.fechaBaja);
		strSql.append(",to_char(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bDelegadosBD.fechaMod).append(",?) as ").append(W83bDelegadosBD.fechaMod);
		strSql.append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoHoraIdiomaInsert(param.getIdioma()));
		strSql.append(W83bDelegadosBD.nombre).append(", ");
		strSql.append(W83bDelegadosBD.sexo).append(", ");
		strSql.append(W83bDelegadosBD.territorioActa).append(", ");
		strSql.append(W83bDelegadosBD.usuario).append(", ");
		strSql.append(W83bDelegadosBD.versionActa);
		
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
		strSql.append(",  ").append(W83bSindicatosBD.sindicatosVista);
		
		strSql.append(" WHERE ");
		if(!bajaVersionAnterior){
			strSql.append(W83bDelegadosBD.dni).append(" = ? ");
			strSql.append(" AND ");
		}else{
			strSql.append(W83bDelegadosBD.baja).append(" is not null ");
			strSql.append(" AND ");			
		}
		strSql.append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.codSindicato).append(" =  ");
		strSql.append(" ").append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND ").append(W83bDelegadosBD.fechaMod).append(" =  ");
		strSql.append("(SELECT max(");
		strSql.append(W83bDelegadosBD.fechaMod).append(") ");
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
		strSql.append(",  ").append(W83bSindicatosBD.sindicatosVista);
		
		strSql.append(" WHERE ");
		if(!bajaVersionAnterior){
			strSql.append(W83bDelegadosBD.dni).append(" = ? ");
			strSql.append(" AND ");
		}else{
			strSql.append(W83bDelegadosBD.baja).append(" is not null ");
			strSql.append(" AND ");			
		}
		strSql.append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ? )");
		
		if(!bajaVersionAnterior){
			params.add(param.getDniDelegado());
		}
		params.add(param.getActaTerritorio());		
		params.add(new Integer(param.getActaAnyo()));		
		params.add(new Integer(param.getActaNum()));		
		if(!bajaVersionAnterior){
			params.add(new Integer(param.getActaVersion()));
		}else{
			
			params.add(new Integer(Integer.parseInt(param.getActaVersion())));			
		}
		if(!bajaVersionAnterior){
			params.add(param.getDniDelegado());
		}
		params.add(param.getActaTerritorio());		
		params.add(new Integer(param.getActaAnyo()));		
		params.add(new Integer(param.getActaNum()));		
		if(!bajaVersionAnterior){
			params.add(new Integer(param.getActaVersion()));
		}else{
			
			params.add(new Integer(Integer.parseInt(param.getActaVersion())));			
		}
		
		
		List listaDelegados = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,null, "detalleDelegado");
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return listaDelegados;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List obtenerRegistrosAuditoria(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		strSql.append("SELECT to_char(");
		strSql.append(W83bIncidenciasAuditoriaBD.FACTU_074).append(",?) as fecha, ");
		strSql.append("  to_char(");
		strSql.append(W83bIncidenciasAuditoriaBD.FACTU_074).append(",?) as hora, ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bClsConstantes.FORMATO_HORA);
		
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(W83bIncidenciasAuditoriaBD.DESC_CAS_074).append(" as ").append(W83bIncidenciasAuditoriaBD.DESC_CAS_074).append(", ");
		}else{
			strSql.append(W83bIncidenciasAuditoriaBD.DESC_EUS_074).append(" as ").append(W83bIncidenciasAuditoriaBD.DESC_CAS_074).append(", ");			
		}
		strSql.append(W83bIncidenciasAuditoriaBD.USUA_074).append(" ");
		
		
		strSql.append(" FROM ").append(W83bIncidenciasAuditoriaBD.incidenciasAuditoriaSinonimo);
		
		strSql.append(" WHERE ").append(W83bIncidenciasAuditoriaBD.ANO_INCID_074).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasAuditoriaBD.C_TERRIT_074).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasAuditoriaBD.N_INCID_074).append(" = ? ");
		strSql.append(" order by ").append(W83bIncidenciasAuditoriaBD.FACTU_074).append(" asc");
		
		params.add(param.getIncidenciaAnyo());		
		params.add(param.getIncidenciaTerritorio());		
		params.add(param.getIncidenciaNumero());		
		
		
		List listaAuditoria = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistorialIncidenciaBean.class,null, null);
	
		return listaAuditoria;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List obtenerRegistrosTramitacion(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasHistorialBD.cod_fase);
		strSql.append(", ");
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(W83bIncidenciasHistorialBD.desc_fase).append(" as ").append(W83bIncidenciasHistorialBD.desc_fase).append(", ");
		}else{
			strSql.append(W83bIncidenciasHistorialBD.dese_fase).append(" as ").append(W83bIncidenciasHistorialBD.desc_fase).append(", ");			
		}
		strSql.append(W83bIncidenciasHistorialBD.cod_tramite);
		strSql.append(", ");
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
			strSql.append(W83bIncidenciasHistorialBD.desc_tramite).append(" as ").append(W83bIncidenciasHistorialBD.desc_tramite).append(", ");
		}else{
			strSql.append(W83bIncidenciasHistorialBD.dese_tramite).append(" as ").append(W83bIncidenciasHistorialBD.desc_tramite).append(", ");			
		}
		strSql.append(W83bIncidenciasHistorialBD.usu_alta).append(", ");
		strSql.append(W83bIncidenciasHistorialBD.usu_mod).append(", ");
		strSql.append("to_char(");
		strSql.append(W83bIncidenciasHistorialBD.f_actu_tramite).append(",?) as ").append(W83bIncidenciasHistorialBD.f_actu_tramite);
		strSql.append(", ");
		strSql.append("to_char(");
		strSql.append(W83bIncidenciasHistorialBD.fecha_mod).append(",?) as ").append(W83bIncidenciasHistorialBD.fecha_mod);
		strSql.append(", to_char(");
		strSql.append(W83bIncidenciasHistorialBD.f_tramite).append(",?) as ").append(W83bIncidenciasHistorialBD.f_tramite);
		
//		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" FROM ").append(W83bIncidenciasHistorialBD.incidenciasHistorialVista);
		
		strSql.append(" WHERE ").append(W83bIncidenciasHistorialBD.ano_incidencia).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.cod_territorio).append(" = ? ");
		strSql.append(" AND ").append(W83bIncidenciasHistorialBD.numincidencia).append(" = ? ");
		params.add(param.getIncidenciaAnyo());		
		params.add(param.getIncidenciaTerritorio());		
		params.add(param.getIncidenciaNumero());		
		
		
		List listaAuditoria = W83bDataBase.executeQuery(strSql.toString(),params,W83bTramiteIncidenciaBean.class,null, null);
		
		return listaAuditoria;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public java.util.List obtenerDocumentosIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasDocsBD.id_doc_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.nomb_docu_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.c_territ_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.ano_incidencia_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.n_incidencia_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.tp_doc_064_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.ID_REMESA_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.COD_REMESA_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.ID_COLECCION_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.COD_COLECCION_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.ID_ENVIO_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.COD_ENVIO_ACUSE_064).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_cas_069_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_eus_069_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_cas_052_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_eus_052_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_cas_012_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.desc_eus_012_vista).append(", ");
		strSql.append(W83bIncidenciasDocsBD.num_reg_064_vista).append(", to_char(");
		strSql.append(W83bIncidenciasDocsBD.f_reg_064_vista).append(",?) as ").append(W83bIncidenciasDocsBD.f_reg_064_vista).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bIncidenciasDocsBD.usuario_064_vista);

		strSql.append(" FROM ").append(W83bIncidenciasDocsBD.docsIncidenciasVista);
		
		strSql.append(" WHERE ").append(W83bIncidenciasDocsBD.c_territ_064_vista).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bIncidenciasDocsBD.ano_incidencia_064_vista).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bIncidenciasDocsBD.n_incidencia_064_vista).append(" = ?");
		
		params.add(param.getIncidenciaTerritorio());		
		params.add(new Integer(param.getIncidenciaAnyo()));
		params.add(new Integer(param.getIncidenciaNumero()));
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, "incidencias");
		
		return listaDocumentos;

	}
	

	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#descargarDocumento(java.lang.String)
	 */
	public W83bDocBean descargarDocumento(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasDocsBD.NOMB_DOCU_064).append(",");
		strSql.append(W83bIncidenciasDocsBD.LONG_DOCU_064).append(",");
		strSql.append(W83bIncidenciasDocsBD.FICHERO_064);
		strSql.append(" FROM ").append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bIncidenciasDocsBD.ID_DOC_064).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, "incidencias");
		
		if (listaDocumentos.size()>0)
			return (W83bDocBean)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarDocsIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean)
	 */
	public void borrarDocsIncidencias(W83bNuevaIncidenciasBean param) throws Exception {	
		if (param.getListaDocsBorrados()!=null && param.getListaDocsBorrados().size()>0)
		{
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
			strSql.append(" WHERE ");
			strSql.append(W83bIncidenciasDocsBD.ID_DOC_064).append(" = ?");
			
			for (int i=0;i< param.getListaDocsBorrados().size();i++)
			{
				String idDoc= (String)param.getListaDocsBorrados().get(i);
				params.add(idDoc);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarSubsanacion(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarSubsanacion(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bSubsanacionesBD.table);
		strSql.append(" WHERE ");
		strSql.append(W83bSubsanacionesBD.C_TERRIT_066);
		strSql.append(" = ? AND ");
		strSql.append(W83bSubsanacionesBD.ANO_INCID_066);
		strSql.append(" = ? AND ");
		strSql.append(W83bSubsanacionesBD.N_INCID_066);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaTipoSustitucion(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaTipoSustitucion(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.incidenciasTipoSustitucionSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.C_TERRIT_067);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.ANO_INCID_067);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasTipoSustitucionBD.N_INCID_067);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaHistorialIncidencia(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaHistorialIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasHistorialBD.incidenciasHistorialSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasHistorialBD.C_TERRIT_072);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasHistorialBD.ANO_INCID_072);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasHistorialBD.N_INCID_072);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaAuditoriaIncidencia(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaAuditoriaIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasAuditoriaBD.incidenciasAuditoriaSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasAuditoriaBD.C_TERRIT_074);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasAuditoriaBD.ANO_INCID_074);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasAuditoriaBD.N_INCID_074);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaDocIncidencia(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaDocIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasDocsBD.C_TERRIT_064);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasDocsBD.ANO_INCID_064);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasDocsBD.N_INCID_064);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaIncidencia(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasBD.N_INCID_061);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaIncidencia(java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaIncidenciaPorActa(String territorioInc, String anyoActa, String numActa, W83bUsuarioXLNetsBean usuarioBean,boolean porActaParcial) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(" = ? ");
		if(!porActaParcial){
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_061);
			strSql.append(" = ? AND ");
			strSql.append(W83bIncidenciasBD.N_ACTA_061);
			strSql.append(" = ? ");
		}else{
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_PARCIAL_061);
			strSql.append(" = ? AND ");
			strSql.append(W83bIncidenciasBD.N_ACTA_PARCIAL_061);
			strSql.append(" = ? ");			
		}
		params.add(territorioInc);		
		params.add(new Integer(anyoActa));
		params.add(new Integer(numActa));
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#borrarTablaDelegados(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public boolean borrarTablaDelegados(String territorioInc, String anyoInc, String numInc, String version, String delegado ,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bDelegadosBD.delegadosTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.versionActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.dni);
		strSql.append(" = ? ");
		params.add(territorioInc);		
		params.add(anyoInc);
		params.add(numInc);
		params.add(version);
		params.add(delegado);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	public String buscarCierre(W83bNuevaIncidenciasBean incidencia,boolean fechaSistema) throws Exception{	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		Calendar calendario = Calendar.getInstance();
		if(!fechaSistema){
			String fechaEntrada = incidencia.getFecValidacion();
			
			java.util.Date dateEntrada= W83bDateUtil.getInstance().stringToDateIdioma(fechaEntrada,incidencia.getIdioma());
			calendario.setTimeInMillis(dateEntrada.getTime());
			calendario.set(Calendar.MONTH,calendario.get(Calendar.MONTH)-1);
		}
		
		strSql.append("SELECT ");
		if(W83bClsConstantes.CONSTANTE_ALAVA.equals(incidencia.getUsuarioBean().getCodTerritorioDelegacion())){
			strSql.append(W83bCierreBD.cierrealava);
		}else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(incidencia.getUsuarioBean().getCodTerritorioDelegacion())){
			strSql.append(W83bCierreBD.cierrebizkaia);
		}else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(incidencia.getUsuarioBean().getCodTerritorioDelegacion())){		
			strSql.append(W83bCierreBD.cierregipuzkoa);
		}
		strSql.append(" AS CIERRE ");
		strSql.append(" FROM ").append(W83bCierreBD.tablacierre);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bCierreBD.anocierre).append(" = ?");
		strSql.append(" AND ").append(W83bCierreBD.mescierre).append(" = ?");
		
		params.add(String.valueOf(calendario.get(Calendar.YEAR)));		
		params.add(String.valueOf(calendario.get(Calendar.MONTH)+1));		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		if(0<lista.size()){
			return ((HashMap)lista.get(0)).get("CIERRE")==null?"":((HashMap)lista.get(0)).get("CIERRE").toString();
		}else{
			return "";
		}
	}
	
	public HashMap buscarNumActaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception{	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bIncidenciasBD.N_ACTA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.ANO_ACTA_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(", ");
		strSql.append(W83bIncidenciasBD.VERSION_ACTA_061);
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bIncidenciasBD.N_INCID_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.ANO_INCID_061).append(" = ?");
		strSql.append(" AND ").append(W83bIncidenciasBD.C_TERRIT_061).append(" = ?");
		
		params.add(new Integer(incidencia.getIncidenciaNumero()));		
		params.add(new Integer(incidencia.getIncidenciaAnyo()));		
		params.add(incidencia.getIncidenciaTerritorio());		

		return (HashMap)W83bDataBase.executeQuery(strSql.toString(),params,null).get(0);
	}

	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIIncidenciasDAO#actualizarDelegadosSustituidosIncidencias(w83b.w83bBeans.W83bDelegadosBean, java.lang.String)
	 */
	public String actualizarDelegadosActaVersionAnterior(String territorioInc, String anyoInc, String numInc, String version,W83bUsuarioXLNetsBean usuarioBean) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuarioBean.getIdUsuario());
		
		strSql.append("UPDATE ") ;
		strSql.append(W83bDelegadosBD.delegadosVista);
		strSql.append(" SET ");
		strSql.append(W83bDelegadosBD.fechaBaja);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bDelegadosBD.dniSustituto);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bDelegadosBD.baja);
		strSql.append(" = ?");

		strSql.append(" WHERE ").append(W83bDelegadosBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ? ");

		strSql.append(" AND ").append(W83bDelegadosBD.fechaBaja).append(" is not null ");
		
		params.add(W83bClsConstantes.NULL_DATE);			
		params.add(W83bClsConstantes.NULL_STRING);			
		params.add(W83bClsConstantes.NULL_STRING);			
		
		params.add(territorioInc);
		params.add(anyoInc);
		params.add(numInc);
		params.add(version);
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
		
		
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return "0";
	}
	
	   /**
	    * Actualiza la informacin de acuse de recibo de una comunicacin de una incidencia
	    * @param docBean W83bDocBean
	    * @throws Exception the exception
	    */
		public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception {
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("UPDATE ");
			strSql.append(W83bIncidenciasDocsBD.docsIncidenciasSinonimo);
			strSql.append(" SET ");
			strSql.append(W83bIncidenciasDocsBD.ID_REMESA_ACUSE_064);
			strSql.append(" = ?, ");
			params.add(docBean.getIdRemesaAcuse());
			strSql.append(W83bIncidenciasDocsBD.COD_REMESA_ACUSE_064);
			strSql.append(" = ?, ");
			params.add(docBean.getCodRemesaAcuse());
			strSql.append(W83bIncidenciasDocsBD.ID_COLECCION_ACUSE_064);
			strSql.append(" = ?, ");
			params.add(docBean.getIdColeccionAcuse());
			strSql.append(W83bIncidenciasDocsBD.COD_COLECCION_ACUSE_064);
			strSql.append(" = ?, ");
			params.add(docBean.getCodColeccionAcuse());
			strSql.append(W83bIncidenciasDocsBD.ID_ENVIO_ACUSE_064);
			strSql.append(" = ?, ");
			params.add(docBean.getIdEnvioAcuse());
			strSql.append(W83bIncidenciasDocsBD.COD_ENVIO_ACUSE_064);
			strSql.append(" = ? ");
			params.add(docBean.getCodEnvioAcuse());
			strSql.append(" WHERE ").append(W83bIncidenciasDocsBD.C_TERRIT_064).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasDocsBD.ANO_INCID_064).append(" = ? ");
			strSql.append(" AND ").append(W83bIncidenciasDocsBD.N_INCID_064).append(" = ? ");
			strSql.append(" AND F_REG_064 IN (select max(F_REG_064) from W83B64T00 where ANO_INCID_064 = ? and N_INCID_064= ?  and C_TERRIT_064= ? " +
												"and c_tram_064 = ? and c_fase_064 = ? ) ");
			params.add(docBean.getNumIncTerritorio());
			params.add(docBean.getNumIncAno());
			params.add(docBean.getNumInc());
			params.add(docBean.getNumIncAno());
			params.add(docBean.getNumInc());
			params.add(docBean.getNumIncTerritorio());
			params.add(docBean.getCodTramite());
			params.add(docBean.getCodFase());
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}
		
	
}
